/***********************************************************
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* Constants shared by radio.c and broadcast.c */

#define BCASTCTLPORT		54319
#define RADIOCTLPORT		54320
#define RCVPORT			54321
#define INFOPORT		54317

#define SAMPLINGRATE		8000

#define BUFFERSIZE		1400
#define CTLPKTSIZE		512
#define INFOFREQ		((30*SAMPLINGRATE) / BUFFERSIZE)

#define HEADERSIZE		2 /* IVS header: 2 bytes (type, encoding) */

#define TYPE_MASK		(3<<6)
#define AUDIO_TYPE		(2<<6)

#define PCM_64			0
#define PCM_32			1
#define ADPCM_32		2
#define VADPCM			3
#define ADPCM_32_W_STATE	66

#ifndef DEFMCAST
#define DEFMCAST		"224.0.2.5"
#endif

#ifndef MULTICAST_TTL
#define MULTICAST_TTL		32
#endif

#define VERSION			"2.0"

#ifdef sgi
#ifndef audiofile
#define USE_AL
#define CHECK_X_SERVER
#endif
#define HAVE_MCAST
#endif

#ifdef sun
#define SUNHACKS
#define USE_SUN
#define CHECK_X_SERVER
#endif

#ifdef NeXT
#define USE_NX
#endif

#ifdef	__hpux
#define	USE_HP
/* #define UseAAPI */		/* No good */
#define	CHECK_X_SERVER
#define	PCKWIN		5
#endif

#ifdef dec_lofi
#define USE_LOFI
#endif

#ifdef audiofile
#define USE_AF
#endif
