.TH RADIO 1
.SH NAME
radio \- receive audio UDP packets transmitted by broadcast
.SH SYNOPSIS
.B radio
[
.B \-c
.I port
] [
.B \-d
] [
.B \-f
] [
.B \-l
.I addr
] [
.B \-m
.I mcastgrp
]
 [
.B \-n
] [
.B \-p
.I port
] [
.B -r
.I addr
] [
.B \-s
] [
.B \-t
] [
.B \-v
.I volume
]
.SH DESCRIPTION
.I Radio
allows you to listen to audio transmitted as UDP packets on a local
area network by
.IR broadcast (1).
Obviously, this requires a workstation with audio hardware; currently
the program works on SGI Indigo and 4D/35 workstations, Sun Sparcs,
all NeXTs, DECStations equipped with DEC LoFi, and any machine running
the Audio File server from DEC CRL.
.PP
.I Radio
is normally run in the background.
You may need a system-specific tool to change the volume or direct the
output to the speaker or headphone jack; e.g., on an SGI, you would
use
.IR apanel (1);
 on a Sun you would use
.IR gaintool (1)
or, when using X,
.IR x_gaintool (1)
(these programs can be found in /usr/demo/SOUND in SunOS 4.1).
With OpenWindows 3.0, you can use
.IR audiotool (1).
(On the NeXT, just use the volume keys on the keyboard.)
.PP
Some loss of UDP packets is tolerated; this is heard as short
interruptions of the sound.
.SH OPTIONS
.TP 10
.BI "\-c " port
Use this UDP port number as control port (default 54320).
Normally you never need to change this; the control port is used by
optional ``tuner'' software (not distributed) and possibly by listener
polling programs.
.TP 10
.B \-d
Turn on debugging (a message on stderr for each 8 packets received,
and when rare or unexpected events happen).
.TP 10
.B \-f
Filter mode: write the U-LAW audio data to stdout instead of
sending it to the audio hardware.
.TP 10
.BI "\-l " addr
Listen only for packets to IP address
.I addr
(useful for forwarding stations).
.TP 10
.BI "\-m " mcastgrp
Multicast group.
This only makes sense if the same multicast group is passed as address to
.IR broadcast (1).
Using multicasting instead of broadcasting reduces the load on
machines that aren't listening.
You should use the same multicast group for all stations on the local network.
(Note that even if a multicast group is specified, stations using broadcasts
can still be picked up by radio).
.TP 10
.B \-n
Noninterruptable mode (Sun Sparc only).
By default,
.I radio
notices when another program wants to open the
audio output device, and temporarily ``backs off'' until the other
program is finished, hoping it won't take too long.
This option turns off that feature.
.TP 10
.BI "\-p " port
Receive packets sent to this UDP port number (default 54321).
This corresponds to the port used by
.I broadcast.
Port numbers 1..99 are shorthands for 54321..54419.
.TP 10
.BI "\-r " addr
Listen only for packets from IP address
.I addr
(useful for forwarding stations).
.TP 10
.B \-s
Secure mode: don't listen to the control port.
This is for really paranoid users: in theory, any user on the net
can override the port specified with \fB\-p\fP by sending a control
message to the control port of your radio program.
.TP 10
.B \-t
Tee mode: write the U-LAW audio data to stdout as well as
sending it to the audio hardware.
.TP 10
.BI "\-v " volume
Set the initial volume, on a scale from 0 to 100.  (SGI and Sun Sparc only.)
By default, the volume is left unchanged.
When the volume is specified this way, its original value is restored
when the program exits.
.SH AUTHOR
Guido van Rossum
.SH VERSION
This manual page documents radio version 2.0, patchlevel 3.
.SH SEE ALSO
broadcast(1), tuner(1), ektuner(1)
.SH COPYRIGHT
Copyright 1991, 1992, 1993 by Stichting Mathematisch Centrum,
Amsterdam, The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
