/*-
 * Copyright (c) 1993, 1994, 1995 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef SMPTE_H
#define SMPTE_H

const unsigned short SMPTE_INSYNC = (1 << 0);
const unsigned short SMPTE_DROPFRAME = (1 << 1);

class SMPTETime {
	friend inline ostream &operator<<(ostream &os, const SMPTETime &t) {
		os << setw(2) << setfill('0') << t.hour << ":"
		    << setw(2) << setfill('0') << t.minute << ":"
		    << setw(2) << setfill('0') << t.second << ":"
		    << setw(2) << setfill('0') << t.frame << ":"
		    << setw(2) << setfill('0') << t.fraction;
		return (os);
	}

public:
	SMPTETime() : hour(0), minute(0), second(0), frame(0), fraction(0),
	    flags(0) {}
	SMPTETime(unsigned short h, unsigned short m, unsigned short s,
	    unsigned short f, unsigned short ff, unsigned short flgs) :
	    hour(h), minute(m), second(s), frame(f), fraction(ff),
	    flags(flgs) {}
	SMPTETime(const SMPTETime &st) : hour(st.hour), minute(st.minute),
	    second(st.second), frame(st.frame), fraction(st.fraction),
	    flags(st.flags) {}
	~SMPTETime() {}

	void SetHour(unsigned short h) {hour = h;}
	void SetMinute(unsigned short m) {minute = m;}
	void SetSecond(unsigned short s) {second = s;}
	void SetFrame(unsigned short f) {frame = f;}
	void SetFraction(unsigned short ff) {fraction = ff;}
	void SetFlags(unsigned short flgs) {flags = flgs;}

	unsigned short GetHour(void) {return (hour);} const
	unsigned short GetMinute(void) {return (minute);} const
	unsigned short GetSecond(void) {return (second);} const
	unsigned short GetFrame(void) {return (frame);} const
	unsigned short GetFraction(void) {return (fraction);} const
	unsigned short GetFlags(void) {return (flags);} const

	SMPTETime &operator=(const SMPTETime &t) {
		hour = t.hour;
		minute = t.minute;
		second = t.second;
		frame = t.frame;
		fraction = t.fraction;
		flags = t.flags;
		return (*this);
	}
private:
	unsigned short hour;
	unsigned short minute;
	unsigned short second;
	unsigned short frame;
	unsigned short fraction;
	unsigned short flags;
};
#endif
