/*-
 * Copyright (c) 1995 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef MIDIIOCTL_H
#define MIDIIOCTL_H
/*
 * SMPTE timing info
 */
struct SMPTE_frame {
	unsigned	char rate;
	unsigned	char hour;
	unsigned	char minute;
	unsigned	char second;
	unsigned	char frame;
	unsigned	char fraction;
	unsigned	char status;
}; 


/*
 * SMPTE status bits
 */
#define SMPTE_SYNC	(1 << 0)	/* indicates we are sync'd */
#define SMPTE_FRAMEDROP	(1 << 1)	/* this is a frame-drop format */
#define SMPTE_FIRST0xF1	(1 << 2)	/* we caught the first 1/4 frame */

/*
 * MPU401 ioctls (/dev/midi and /dev/smpte)
 */
#define MRESET		_IO('m', 0x01)
#define MDRAIN		_IO('m', 0x02)
#define MFLUSH		_IO('m', 0x03)
#define MGPLAYQ		_IOR('m', 0x04, int)
#define MGRECQ		_IOR('m', 0x05, int)
#define MSDIVISION	_IOW('m', 0x06, int)
#define MGDIVISION	_IOR('m', 0x07, int)
#define MGQAVAIL	_IOR('m', 0x08, int)
#define MASYNC		_IOW('m', 0x09, int)
#define MTHRU		_IOW('m', 0x0a, int)
#define MRECONPLAY	_IOW('m', 0x0b, int)
#define MGSMPTE		_IOR('m', 0x0c, struct SMPTE_frame)
#define MGSMFTIME	_IOR('m', 0x0d, unsigned long)
#define MGTHRU		_IOR('m', 0x0e, int)
#endif
