%{
#include "b.tab.h"
#include <X11/Intrinsic.h>
#include "bibview.h"

extern char yylval;
extern int ueIdx;
extern char uebergabe[];
extern int yynline;
extern int yynflexcalls;


%}


%%


"\\%"         {
               yynflexcalls += 1;
               uebergabe[ueIdx] = yytext[0];
               uebergabe[ueIdx+1] = yytext[1];
               uebergabe[ueIdx+2] = '\0';
               ueIdx += 2;
               yylval = yytext[0];
	       return PROZENT;
	     }

"%".*\n      { 
               yynflexcalls += 1;
               yylval = yytext[0];
               yynline += 1;
	       return KOMMENTAR;
	     }

"@comment"  {
            yynflexcalls += 1;
	    return COMMENT; 
            }

"@string"  {
            yynflexcalls += 1;
	    return STRING; 
           }

"@preamble"  {
              yynflexcalls += 1;
              return PREAMBLE; 
             }

"@"[a-zA-Z]*      {
		   strcpy(uebergabe, &yytext[1]);
		   ueIdx += strlen(yytext);
                   yynflexcalls += 1;
	           return TYPE; 
                  }

"#"        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return ZAUN;
           }


","        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return KOMMA;
           }

"("        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return LRKL;
           }

")"        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return RRKL;
           }

"{"        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return LGKL;
           }

"}"        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return RGKL;
           }

"="        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return EQ;
           }

[\"]        {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return DAZ;
           }

[ \t\n]    {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             if (yytext[0] == '\n') yynline += 1;
             return WHITE_SPACE;
           }

[a-zA-Z0-9]  {
               yynflexcalls += 1;
               yylval = yytext[0];
               uebergabe[ueIdx] = yytext[0];
               uebergabe[ueIdx+1] = '\0';
               ueIdx++;
               return BUCHSTABE_ZAHL;
             }

<<EOF>>  {
           yynflexcalls += 1;
           YY_NEW_FILE;
           ueIdx = 0;
           return 0;
         }

.          {
             yynflexcalls += 1;
             yylval = yytext[0];
             uebergabe[ueIdx] = yytext[0];
             uebergabe[ueIdx+1] = '\0';
             ueIdx++;
             return ZEICHEN;
           }


%%

