/* screenio.h - 22:01 GMT +10:00 Fri 23 July 1993 - modifier Geoffrey Tobin */

#ifndef SCREENIO_H
#define SCREENIO_H

/* Include file ../include/screenio.h from vis630vdu.c */


/* 0 = success, 1 = error */
/* These terminal i/o routines are highly system-dependent and have been
   designed for DVItoVDU and its auxiliary modules.

   Notes:
 - InitScreenIO saves the current tty characteristics,
   then sets the mode to cbreak with no echo.
   Clients should therefore call RestoreTerminal before terminating.
 - WriteFlush or WriteLine must be called to explicitly update the terminal
   (e.g., just before a read) or to synchronize output with writes
   from other modules that don't use ScreenIO.
 - WriteString assumes the end of a string is the first blank (if not full),
   so clients need to replace calls like WriteString('xxx = ') with
   WriteString('xxx ='); WriteChar(' ').
*/

#define CR              '\n'   /* SYSDEP: char read upon hitting Return key */
#define CTRLC           '\0'   /* SYSDEP: interrupt, see unixio */
#define CTRLZ           '\001'   /* SYSDEP: suspend, see unixio */
/* SYSDEP: unixio puts CTRLC and CTRLZ into input buffer (along with CR)
   upon getting a ^C or ^Z interrupt.
   (It can't put chr(3) and chr(26) into buffer
   because tty will detect another interrupt and we'll loop forever!)
*/
#define NUL             '\0'
#define FF              '\f'
#define CAN             '\030'
#define ESC             '\033'
#define FS              '\034'
#define GS              '\035'
#define US              '\037'
#define XXX             256


extern int textlinewidth;  /* text characters (columns) per line */
extern int textcolumn;     /* column in current text line */

extern Char TeXtoASCII[XXX];   /* TeX char to ASCII char */

extern Void BreakGraphics (VOID);
extern Void RestoreGraphics (VOID);

extern Void InitScreenIO (VOID);
extern Void ReadChar __((Char *ch));
extern Void ReadString __((Char *s));
extern boolean BusyRead __((Char *ch));
extern Void WriteInt __((int i));
extern Void WriteLine (VOID);

#define WriteChar(X) putchar(X)
#define WriteString(X) fputs(X, stdout)
#define WriteFlush() fflush(stdout)

extern int MesgInt __((int i));
extern Void MesgLine (VOID);

extern int MesgChar __((int ch));
extern int MesgString __((const char * s));
extern int MesgFlush (VOID);

extern Void FatalError __((const char * s));

extern Void RestoreTerminal (VOID);

#endif /* SCREENIO_H */

/* end screenio.h */
