/* kpsexpand -- do Kpathsea variable expansion, pretending to be a given
   program.  For example,
     prompt$ kpsexpand latex2e '$TEXINPUTS'
   expands $TEXINPUTS for latex2e.

   Based on code from te@informatik.uni-hannover.de.  */

/* Not worth chance of collisions to #include anything but this.  */
#include <stdio.h> /* for stderr */
#include <kpathsea/debug.h> /* for stderr */

extern char *kpse_var_expand ();
extern void kpse_set_progname ();

int
main (argc, argv)
    int argc;
    char *argv[];
{
  char *mode, *virtname=argv[0], *progname=argv[0];

  while (--argc > 0 && (*++argv)[0] == '-')
    {
      switch (argv[0][1])
        {
          case 'd':
            debug = atoi((++argv)[0]);
            --argc;
            break;
          case 'n':
            virtname = (++argv)[0];
            --argc;
            break;
          case 'm':
            mode = (++argv)[0];
            --argc;
            break;
          default:
            ;
        }
    }

  if (argc != 1)
    {
      fprintf (stderr, "Usage: [-d debug] [-m mode] [-n progname] string\n", argv[0]);
      exit (1);
    }
  kpse_set_progname (virtname);
  printf ("%s\n", kpse_var_expand (argv[2]));
  return 0;
}
