proc TextBind {w} {

  bind $w.text <Up>    "TedPos $w insert - 1 l"
  bind $w.text <Down>  "TedPos $w insert + 1 l"
  bind $w.text <Left>  "TedPos $w insert - 1 c"
  bind $w.text <Right> "TedPos $w insert + 1 c"
  bind $w.text <Control-Right> "TedPos $w insert wordend"
  bind $w.text <Control-Left>  "TedPos $w insert - 1 c 
    TedPos $w insert wordstart"
  bind $w.text <Prior> "TedPos $w insert - 15 l"
  bind $w.text <Next>  "TedPos $w insert + 15 l"
  bind $w.text <Home>  "TedPos $w insert linestart"
  bind $w.text <End>   "TedPos $w insert lineend"
  bind $w.text <Control-Prior> "TedPos $w 1.0"
  bind $w.text <Control-Next>  "TedPos $w end"
  bind $w.text <Shift-Right> "TedMark $w + 1 c"
  bind $w.text <Shift-Left> "TedMark $w - 1 c"
  bind $w.text <Shift-Down> "TedMark $w + 1 l"
  bind $w.text <Shift-Up>   "TedMark $w - 1 l"
  bind $w.text <Shift-Home> "TedMark $w linestart"
  bind $w.text <Shift-End>  "TedMark $w lineend"
  bind $w.text <Control-t> "TedDelWord $w"
  bind $w.text <Control-y> "TedDelLine $w"
  bind $w.text <Control-k> "set ted_stblock($w) 1"
  bind $w.text <Control-x> "TedCut $w"
  bind $w.text <Control-c> "TedCut $w copy"
  bind $w.text <Control-v> "TedPaste $w"
  bind $w.text <Control-Delete> "TedDelMark $w"
  bind $w.text <Control-w> "$w.wrap invoke"
  bind $w.text <Alt-Any-F3>  "TedExit $w"
  bind $w.text <F2> "TedSaveAs $w 0"
  bind $w.text <Control-F2> "TedSaveAs $w 1"
  bind $w.text <F1>      "help teditmain"
  bind $w.text <Control-F1> "TedContextHelp $w"
  bind $w.text <Control-Any-q><Any-l> "TedGoto $w"
  bind $w.text <Control-Any-q><Any-f> "TedSearch $w"
  bind $w.text <Control-Any-q><Any-a> "TedReplace $w"
  bind $w.text <Control-l> "TedReplaceNext $w"
  bind $w.text <2>       "TedInsSel $w"
  bind $w.text <Any-Key> "TedInsert $w %A"
}

proc GlobalBind {w} {

  bind $w <Alt-Any-x> {Exit}
  bind $w <F3> {Edit}
  bind $w <Alt-Any-0> {EditPrim}
  bind $w <F13>      {Primary}
  bind $w <Shift-F3> {Primary}
  bind $w <F5> {Graphic}
  bind $w <F6> {Compose}
  bind $w <F7> {Reference}
  bind $w <F8> {View}
  bind $w <F9> {Print}
  bind $w <F11> {tk_mbPost .b.butil; .b.butil.m activate 0}
  bind $w <Control-F3> "selectparams Edit"
  bind $w <Control-F5> "selectparams Graphic"
  bind $w <Control-F6> "selectparams Compose"
  bind $w <Control-F7> "selectparams Reference"
  bind $w <Control-F8> "selectparams View"
  bind $w <Control-F9> "selectparams Print"
  bind $w <Control-F11> "selectparams Util"
  bind $w <Alt-Any-F5>  "focusLog"

  for {set i 1} {$i < 10} {incr i} {
    bind $w <Alt-Any-Key-$i> "Edit $i"
  }
}
