# Kommandoausf"uhrung im Textwidget

proc focusLog {} {
  global params
  
  set old_focus [focus]
  if {$params(ShowOut)} {
   raise .t 
  } else {
    wm deiconify .t
  }
  .t.text mark set insert end
  .t.text insert insert \n
  .t.text mark set pos insert
  .t.text insert insert "---Press-Q-to-Quit---\n"
  .t.text yview -pickplace pos
  set params(log_end) ""
  xfocus .t.text 
  bind .t.text <Down> {
    %W mark set insert "insert + 1 l"
    %W yview -pickplace insert
  }
  bind .t.text <Up> {
    %W mark set insert "insert - 1 l"
    %W yview -pickplace insert
  }
  bind .t.text <Next> {
    %W mark set insert "insert + 15 l"
    %W yview -pickplace insert
  }
  bind .t.text <Prior> {
    %W mark set insert "insert - 15 l"
    %W yview -pickplace insert
  }
  bind .t.text <Any-Key> {
    %W insert insert "\n QUIT "
    %W yview -pickplace insert
    set params(log_end) end
  }
  tkwait variable params(log_end)
  bind .t.text <Any-Key> { }
  .t.text mark set insert end
  xfocus $old_focus
  update idletasks
  if {!$params(ShowOut)} {
    wm withdraw .t
  }
}

proc catfile {file} {
  global params
  
  set old_focus [focus]
  if {$params(ShowOut)} {
   raise .t 
  } else {
    wm deiconify .t
  }
  .t.text mark set insert end
  .t.text insert insert \n
  set pos [.t.text index insert]
  .t.text insert insert \
  "--- $file -------------------------------------\n"
  if {[catch {set fd [open $file r]} msg]} {
    OutMsg $msg
    return
  }
  while {![eof $fd]} {
    if {[gets $fd s] != -1} {
      .t.text insert insert $s\n
    }
  }
  .t.text insert insert "---End-of-file---Press-Q-to-Quit---\n"
  close $fd
  set params(log_end) ""
  .t.text mark set insert $pos
  .t.text yview insert
  xfocus .t.text 
  bind .t.text <Down> {
    %W mark set insert "insert + 1 l"
    %W yview -pickplace insert
  }
  bind .t.text <Up> {
    %W mark set insert "insert - 1 l"
    %W yview -pickplace insert
  }
  bind .t.text <Next> {
    %W mark set insert "insert + 15 l"
    %W yview -pickplace insert
  }
  bind .t.text <Prior> {
    %W mark set insert "insert - 15 l"
    %W yview -pickplace insert
  }
  bind .t.text <Any-Key> {
    switch -regexp -- "%A" {
      \003 {
        %W insert insert "\n INT "
        %W yview -pickplace insert
        set cmd(end) end
      }
      \004 {
        %W mark set insert end
        %W insert insert "\n EOF "
        %W yview -pickplace insert
        set params(log_end) end
      }
      \r {
        %W mark set insert "insert + 1 lines"
        %W yview -pickplace insert
      }
      [qQ] {
        %W insert insert "\n QUIT "
        %W yview -pickplace insert
        set params(log_end) end
      }
    }
  }
  tkwait variable params(log_end)
  bind .t.text <Any-Key> { }
  .t.text mark set insert end
  xfocus $old_focus
  update idletasks
  if {!$params(ShowOut)} {
    wm withdraw .t
  }
}

proc StartTty {} {
  global params

  # Open pipes for program output
  pipe params(or) params(ow)
  pipe params(er) params(ew)
  addinput -read $params(or) COut
  addinput -read $params(er) CErr
  fcntl $params(or) NONBLOCK 1
  fcntl $params(er) NONBLOCK 1
}

proc StopTty {} {
  global params

  removeinput $params(or)
  removeinput $params(er)
  close $params(ow)
  close $params(ew)
  close $params(or)
  close $params(er)
}

proc COut {} {
  global params

  set c [read $params(or)]
  .t.text insert insert "$c"
  .t.text yview -pickplace insert
  update
}

proc CErr {} {
  global params

  set c [read $params(er)]
  .t.text insert insert "$c"
  .t.text yview -pickplace insert
  update
}

# ExecCmd cmdlist
# cmdlist: {cmd opt} ...
proc ExecCmd {command opt} {
  global params

  if {$params(pid) > 1} {
    Warning $params(dlg_geom) \
      "Process $params(pid) still running\nKill it or wait."
      return
  }
  set old_focus [focus]
  if {$params(ShowOut)} {
    raise .t
  } else {
    wm deiconify .t
  } 
  set params(cmd_buf) ""
  xfocus .t.text
  bind .t.text <Any-Key> {
    switch -- "%A" {
      \003 {
        kill SIGKILL $params(pid)
        %W insert insert " INT "
        %W yview -pickplace insert
      }
      \004 {
        flush $params(iw)
        close $params(iw)
        %W insert insert " EOF "
        %W yview -pickplace insert
      }
      \b {
        set l [string length $params(cmd_buf)]
        if {$l > 0} {
          set params(cmd_buf) [string range $params(cmd_buf) 0 [expr $l - 2]]
          %W delete "insert - 1 c"
          %W yview -pickplace insert
        }
      }
      \r {
        %W insert insert \n
        %W yview -pickplace insert
        puts $params(iw) $params(cmd_buf)
        flush $params(iw)
        set params(cmd_buf) ""
      }
      default {
        append params(cmd_buf) %A
        %W insert insert %A
        %W yview -pickplace insert
      }
    }
  }
  .t.text mark set insert end
  .t.text insert insert \n
  pipe ir iw
  if {[set params(pid) [fork]] == 0} {
    # Child process
    close $iw
    close $params(or)
    close $params(er)

    dup $ir stdin
    dup $params(ow) stdout
    dup $params(ew) stderr
    close $ir
    close $params(ow)
    close $params(ew)

     execl $command $opt
     exit
  }
  # Parent
  close $ir
  set params(iw) $iw
  
  tkwait variable params(pid)
  .t.text mark set insert end
  if {!$params(ShowOut)} {
    wm withdraw .t
  }
  bind .t.text <Any-Key> { }
  xfocus $old_focus
}

proc CmdKill {} {
  global params pid

  set res [catch "wait -nohang $params(pid)" msg]
  debug "CmdKill: $res $msg"
  if {$res == 0 && $msg != ""} {
    set params(pid) 1
    if {![eof $params(or)]} {COut}
    if {![eof $params(er)]} {CErr}
    catch {close $params(iw)}
    return
  } elseif {$params(pid) == 1} {
  }
  set i 0
  while {$i < [llength $pid]} {
    set P [lindex $pid $i]
    set p [lindex $P 0]
    set res [catch "wait -nohang $p" msg]
    if {$res == 0 && $msg != ""} {
      set cmd [lindex $P 1]
      OutMsg "Process $p: $cmd died: $msg"
      set pid [lreplace $pid $i $i]
    } else {
      incr i
    }
  }
}
