# FileDialog procedures

proc FDreadfiles {} {
  global fd

  .td.mid.l.file delete 0 end
  .td.mid.l.files delete 0 end
  .td.mid.r.dirs delete 0 end
  set fd(lfiles) {}
  set fd(ldirs) {}
  foreach i [lsort [glob -nocomplain *$fd(ext)]] {
    if [file isfile $i] {
      .td.mid.l.files insert end $i
      lappend fd(lfiles) $i
    }
  } 
  foreach i [lsort [glob .* *]] {
    if [file isdir $i] {
      .td.mid.r.dirs insert end $i
      lappend fd(ldirs) $i
    }
  }
}

proc FDChangeDir {i} {
  global fd env

  cd [.td.mid.r.dirs get $i]
  set fd(pwd) [pwd]
  if {[string first $env(HOME) $fd(pwd)] == 0} {
    set fd(pwd) "~[string range $fd(pwd) [clength $env(HOME)] end]"
  }
  FDreadfiles 
  set fd(selfile) 0
  FDSelect .td.mid.r.dirs 0
}

proc FDSetFile {i} {
  global fd

  .td.mid.l.file delete 0 end
  .td.mid.l.file insert 0 [.td.mid.l.files get $i]
  FDSelect .td.mid.l.files $i
}

proc FDSelect {w i} {
  global fd

  $w select from $i
  $w select to $i
  if {$w == ".td.mid.l.files"} {
    set l [.td.mid.l.sbf get]
    set fd(selfile) $i
  } else {
    set l [.td.mid.r.sbd get]
    set fd(seldir) $i
  }
  set min [lindex $l 2]
  set max [lindex $l 3]
  if {$i < $min} {
    $w yview $i
  } elseif {$i > $max} {
    $w yview [expr $min + $i - $max]
  }
}

proc FDNext {w} {
  global fd

  if {$w == ".td.mid.l.files"} {
    set i $fd(selfile)
  } else {
    set i $fd(seldir)
  }
  incr i
  if {$i >= [$w size]} {
    set i [expr [$w size] - 1]
  }
  FDSelect $w $i
}

proc FDPrev {w} {
  global fd

  if {$w == ".td.mid.l.files"} {
    set i $fd(selfile)
  } else {
    set i $fd(seldir)
  }
  incr i -1
  if {$i < 0} {
    set i 0
  }
  FDSelect $w $i
}

proc FDLetter {w a} {
  global fd

  if {$w == ".td.mid.l.files"} {
    set l $fd(lfiles)
  } else {
    set l $fd(ldirs)
  }
  set i [lsearch -glob $l ${a}*]
  if {$i > -1} {
    FDSelect $w $i
  } else {
    puts \a
  }
}

proc FDFocusFiles {} {
  global fd

  focus .td.mid.l.files
  .td.mid.r.dirs select clear
  FDSelect .td.mid.l.files $fd(selfile)
}

proc FDFocusDirs {} {
  global fd

  focus .td.mid.r.dirs
  .td.mid.l.files select clear
  FDSelect .td.mid.r.dirs $fd(seldir)
}

proc FDFocusFile {} {
  focus .td.mid.l.file
  .td.mid.l.files select clear
  .td.mid.r.dirs select clear
}

proc FDOK {} {
  global fd

  set f [.td.mid.l.file get]
  if {$f != ""} {
    set fd(return) 1
  } else {
    FDFocusFiles
  }
}

proc FDCancel {} {
  global fd
  set fd(return) 0
}

proc FileDialog {geom atitle {ext ""} filename} {
  global fd env
  upvar $filename fn

  toplevel .td 
  wm transient .td .
  wm geometry .td $geom 
  frame .td.top -relief raised -bd 1
  frame .td.mid -relief raised -bd 1
  frame .td.ext -relief raised -bd 1
  frame .td.bot -relief raised -bd 1
  pack .td.top .td.mid .td.ext .td.bot -fill x

  frame .td.mid.l
  frame .td.mid.r
  pack .td.mid.l -side left -fill y -padx 5
  pack .td.mid.r -side left -fill y -padx 5

  label .td.top.title -text $atitle
  pack .td.top.title

  label .td.ext.lm -text "\[E\]xtension:"
  entry .td.ext.ext -relief sunken -textvariable fd(ext)
  pack .td.ext.lm .td.ext.ext -side left

  frame .td.bot.fok -bd 1 -relief sunken
  button .td.bot.ok -text "OK" -command "FDOK"
  button .td.bot.cancel -text "Cancel" -command "FDCancel"
  pack .td.bot.fok .td.bot.cancel -side left -padx 10 -pady 10
  pack .td.bot.ok -padx 5 -pady 5 -in .td.bot.fok

  label .td.mid.l.lf -text "File:"
  entry .td.mid.l.file -relief sunken -textvariable fd(fn)
  listbox .td.mid.l.files -yscroll ".td.mid.l.sbf set" -relief sunken \
    -exportselection no
  scrollbar .td.mid.l.sbf -command ".td.mid.l.files yview"
  pack .td.mid.l.lf .td.mid.l.file -fill x
  pack .td.mid.l.files -side left
  pack .td.mid.l.sbf -side left -fill y

  label .td.mid.r.ld -text "Directory:"
  entry .td.mid.r.dir -relief sunken -textvariable fd(pwd) -width 30
  listbox .td.mid.r.dirs  -yscroll ".td.mid.r.sbd set" -relief sunken \
    -exportselection no
  scrollbar .td.mid.r.sbd -command ".td.mid.r.dirs yview"
  pack .td.mid.r.ld .td.mid.r.dir -side top -fill x
  pack .td.mid.r.sbd -side right -fill y
  pack .td.mid.r.dirs -side left -fill both -expand 1
  tk_listboxSingleSelect .td.mid.l.files .td.mid.r.dirs

  bind .td.mid.l.files <Up> {FDPrev %W}
  bind .td.mid.r.dirs <Up> {FDPrev %W}
  bind .td.mid.l.files <Down> {FDNext %W}
  bind .td.mid.r.dirs <Down> {FDNext %W}
  bind .td.mid.l.files <Any-KeyPress> {FDLetter %W %A}
  bind .td.mid.r.dirs <Any-KeyPress> {FDLetter %W %A}

  bind .td.mid.r.dirs <1> {FDSelect %W [%W nearest %y]; FDFocusDirs}
  bind .td.mid.r.dirs <Double-1> {FDChangeDir [.td.mid.r.dirs nearest %y]}
  bind .td.mid.r.dirs <Return> {FDChangeDir $fd(seldir)}
  bind .td.mid.l.files <1> {
    FDSetFile [.td.mid.l.files nearest %y] 
    FDFocusFiles
  }
  bind .td.mid.l.files <Return> {FDSetFile $fd(selfile); FDOK}
  bind .td.mid.l.file <Return> {FDOK}

  bind .td.mid.l.file <Tab> {FDFocusFiles}
  bind .td.mid.l.files <Tab> {FDFocusDirs}
  bind .td.mid.r.dirs <Tab> {FDFocusFile}
  bind .td.mid.l.file <Shift-Tab> {FDFocusDirs}
  bind .td.mid.l.files <Shift-Tab> {FDFocusFile}
  bind .td.mid.r.dirs <Shift-Tab> {FDFocusFiles}

  bind .td.ext.ext <Return> "FDreadfiles ; FDFocusFile"
  foreach w \
  {.td.ext.ext .td.mid.r.dirs .td.mid.r.dir .td.mid.l.files .td.mid.l.file} {
    bind $w <Control-Return> {set fd(return) 1}
    bind $w <Escape> FDCancel
    bind $w <Alt-Any-e>  "focus .td.ext.ext"
  }
  set fd(ext) $ext
  set old_wd [pwd]
  set fd(pwd) [file dirname $fn]
  if {$fd(pwd) == "."} {set fd(pwd) $old_wd}
  if {[string first $env(HOME) $fd(pwd)] == 0} {
    set fd(pwd) "~[string range $fd(pwd) [clength $env(HOME)] end]"
  }
  cd $fd(pwd)
  FDreadfiles
  set fd(fn) [file tail $fn]
  set fd(selfile) 0
  set fd(seldir) 0
  set fd(return) ""
  set oldfocus [focus]
  grab .td
  FDFocusFile
  tkwait variable fd(return)
  focus $oldfocus
  if $fd(return) {
    if {$fd(fn) != "" && [file extension $fd(fn)] == ""} {
      set fd(fn) $fd(fn)$fd(ext)
    }
    set fn [pwd]/$fd(fn)
  }
  cd $old_wd
  destroy .td
  return $fd(return)
}
