proc PrintDlg {geometry file params} {
  global prd
  upvar $params pr

  toplevel .prd
  wm geometry .prd $geometry
  wm transient .prd .

  set prd(first) $pr(pr_first)
  set prd(last)  $pr(pr_last)
  set prd(copies) $pr(pr_copies)
  set prd(xopt) $pr(pr_xopt)
  if {$pr(pr_pages) == ""} { 
    set prd(pages) "all" 
  } else {
    set prd(pages) $pr(pr_pages) 
  } 
  if {$pr(pr_orientation) == ""} {
    set prd(orientation) "portrait" 
  } else { 
    set prd(orientation) $pr(pr_orientation)
  }
  frame .prd.ft -relief raised -bd 1
  pack .prd.ft -fill x
  label .prd.ft.lt -text "Print parameters for $file"  \
    -width 35 -anchor w
  pack .prd.ft.lt -side left -pady 5 -padx 5

  frame .prd.ff -relief raised -bd 1
  pack .prd.ff -fill x
  label .prd.ff.lf -text "First page:" -width 15  -anchor w
  entry .prd.ff.ef -relief sunken -font fixed -width 4 \
    -textvariable prd(first)
  pack .prd.ff.lf -side left -padx 5
  pack .prd.ff.ef -side right -padx 5

  frame .prd.fl -relief raised -bd 1
  pack .prd.fl -fill x
  label .prd.fl.ll -text "Last page:" -width 15  -anchor w
  entry .prd.fl.el -relief sunken -font fixed -width 4 \
    -textvariable prd(last)
  pack .prd.fl.ll -side left -padx 5
  pack .prd.fl.el -side right -padx 5

  frame .prd.fc -relief raised -bd 1
  pack .prd.fc -fill x
  label .prd.fc.lc -text "Number of copies:" -width 15  -anchor w
  entry .prd.fc.ec -relief sunken -font fixed -width 4 \
    -textvariable prd(copies) 
  pack .prd.fc.lc -side left -padx 5
  pack .prd.fc.ec -side right -padx 5

  frame .prd.fx -relief raised -bd 1
  pack .prd.fx -fill x
  label .prd.fx.lx -text "Extra Options:" -width 15  -anchor w
  entry .prd.fx.ex -relief sunken -font fixed -width 20 \
    -textvariable prd(xopt) 
  pack .prd.fx.lx -side left -padx 5
  pack .prd.fx.ex -side right -padx 5

  frame .prd.fpo -relief raised -bd 1
  pack .prd.fpo -fill x
  
  frame .prd.fp
  pack .prd.fp -side left -padx 5 -pady 5 -in .prd.fpo
  label .prd.fp.lp -text "Page selection" -anchor w 
  radiobutton .prd.fp.rall -text "\[A\]ll pages" -anchor w -font fixed \
    -variable prd(pages) -value "all"
  radiobutton .prd.fp.rodd -text "\[O\]dd pages" -anchor w -font fixed \
    -variable prd(pages) -value odd
  radiobutton .prd.fp.reven -text "\[E\]ven pages" -anchor w -font fixed \
    -variable prd(pages) -value even
  pack .prd.fp.lp .prd.fp.rall .prd.fp.rodd .prd.fp.reven -fill x
  
  frame .prd.fo
  pack .prd.fo -side right -padx 5 -pady 5 -fill y -in .prd.fpo
  label .prd.fo.lo -text "Orientation" -anchor w 
  radiobutton .prd.fo.rp -text "\[P\]ortrait" -anchor w -font fixed \
    -variable prd(orientation) -value "portrait"
  radiobutton .prd.fo.rl -text "\[L\]andscape" -anchor w -font fixed \
    -variable prd(orientation) -value landscape
  pack .prd.fo.lo .prd.fo.rp .prd.fo.rl -fill x

  frame .prd.fb -relief raised -bd 1
  pack .prd.fb -fill x
  frame .prd.fb.fok -relief sunken -bd 2
  button .prd.fb.ok -text OK  -command {set prd(ok) 1}
  button .prd.fb.cancel -text Cancel  \
    -command {set prd(ok) 0}
  pack .prd.fb.fok -side left -padx 5 -pady 5
  pack .prd.fb.ok -padx 5 -pady 5 -in .prd.fb.fok
  pack .prd.fb.cancel -padx 10 -pady 5 -side left

  set elist [list .prd.ff.ef .prd.fl.el .prd.fc.ec .prd.fx.ex]
  for {set i 0} {$i < 4} {incr i} {
    set w [lindex $elist $i]
    if {$i > 0} {
      set wp [lindex $elist [expr $i - 1]]
    } else {set wp .prd.fc.ec}
    if {$i < 3} {
      set wn [lindex $elist [expr $i + 1]]
    } else {set wn .prd.ff.ef}
    bind $w <Return>         "focus $wn"
    bind $w <Tab>            "focus $wn"
    bind $w <Shift-Tab>      "focus $wp"
    bind $w <Control-Return> "set prd(ok) 1"
    bind $w <Escape>         "set prd(ok) 0" 
    bind $w <Alt-Any-a>	     "set prd(pages) all"
    bind $w <Alt-Any-o>	     "set prd(pages) odd"
    bind $w <Alt-Any-e>	     "set prd(pages) even"
    bind $w <Alt-Any-p>	     "set prd(orientation) portrait"
    bind $w <Alt-Any-l>	     "set prd(orientation) landscape"
  }
  set old_focus [focus]
  focus .prd.ff.ef
  tkwait variable prd(ok)
  if {$prd(ok)} {
    set pr(pr_first) $prd(first)
    set pr(pr_last)  $prd(last)
    set pr(pr_copies) $prd(copies)
    set pr(pr_xopt) $prd(xopt)
    if {$prd(pages) == "all"} { 
      set pr(pr_pages) "" 
    } else {
      set pr(pr_pages) $prd(pages) 
    } 
    if {$prd(orientation) == "portrait"} {
      set pr(pr_orientation) "" 
    } else { 
      set pr(pr_orientation) $prd(orientation)
    }
  }
  destroy .prd
  focus $old_focus
  return $prd(ok)
}
