proc SearchDlg {geom typ search replace} {
  global ok
  upvar $search s
  upvar $replace r

  #SearchDlg
  toplevel .td
  switch $typ {
    0 {wm title .td "Search"}
    1 {wm title .td "Search & Replace"}
  }
  wm geometry .td $geom
  frame .td.fs
  frame .td.fr
  frame .td.fo
  pack .td.fs .td.fr .td.fo -fill x -pady 5 -side top

  frame .td.fo1
  frame .td.fo2
  frame .td.fo3
  pack .td.fo1 .td.fo2 .td.fo3 -side left -padx 5 -fill y -in .td.fo

  label .td.ls -text "Search for:" -font fixed -width 13
  entry .td.es -relief sunken -textvariable s
  pack .td.ls .td.es -side left -in .td.fs

  if {$typ} {
    label .td.lr -text "Replace with:" -font fixed -width 13
    entry .td.er -relief sunken -textvariable r
    pack .td.lr .td.er -side left -in .td.fr
  }

  checkbutton .td.case -text "Case-sensitive" -anchor w
    pack .td.case -fill x -in .td.fo1 
  if {$typ} {
    checkbutton .td.prompt -text "Prompt on replace" -anchor w
    checkbutton .td.all -text "Replace all" -anchor w
    pack .td.prompt .td.all -fill x -in .td.fo1 
  }

  radiobutton .td.first -text  "Whole text"  -anchor w
  radiobutton .td.cursor -text "From Cursor" -anchor w
  pack .td.first .td.cursor -fill x -in .td.fo2

  radiobutton .td.forw -text "Forward" -anchor w
  radiobutton .td.backw -text "Backward" -anchor w
  pack .td.forw .td.backw -fill x -in .td.fo3

  frame .td.fok -borderwidth 2 -relief sunken
  frame .td.fcancel
  pack .td.fok .td.fcancel -padx 5 -pady 5 -side left
  button .td.bok -text "Ok" -command {set ok 1}
  pack .td.bok -padx 5 -pady 5 -in .td.fok
  button .td.bcancel -text "Cancel" -command {set ok 0}
  pack .td.bcancel -padx 5 -pady 5 -in .td.fcancel
  set oldfocus [focus]
  focus .td
  set ok 0
  tkwait variable ok
  destroy .td
  focus $oldfocus
  return $ok
}
