/* -*- c++ -*- 
   Header file for the executable class */

#pragma interface

#include <a.out.h>

class executable {
    int fd;
    unsigned int start;		// Starting core address of file
    unsigned int filesize;	// Number of pc/count pairs in file
    nlist* cursym;		// Current symbol in the file
    nlist* maxsym;		// Points just after the last symbol
    char* strs;			// The string table
    unsigned int clow;		// Low pc value of current line
    unsigned int chigh;		// High pc value of current line
    const char* cdir;		// Current directory name
    const char* cfile;		// Current file name
    int cline;			// Current line number
    time_t _mtime;		// Modification time of file
public:
    executable(const char* = "a.out");
    ~executable(void);

    /* The lowest and (highest+1) value of the program counter in the
       current line */
    unsigned int lowpc(void) const { return clow; }
    unsigned int highpc(void) const { return chigh; }

    /* dirname contains the directory of the main source file.
       filename contains either a file in dirname or a complete
       pathname if such was specified in the symbol table */
    const char* dirname(void) const { return cdir; }
    const char* filename(void) const { return cfile; }

    /* The current line number */
    int lineno(void) const { return cline; }

    /* Go to the next line in the program */
    int shift(void);

    /* Get the modification time of the file */
    time_t mtime(void) const { return _mtime; }
};
