#!/usr/bin/perl -w
# universal shlib builder v.0.1
#
# 	- Patrick Nguyen (pnguyen@elde.epfl.ch) (aka MegaFork)
# my 2nd perl script (using perl5).
# 
#*****************************************************************************#
#*	This program has been written by Patrick Nguyen			     *#
#* You may distribute, copy, modify, use this program in any manner you wish *#
#* providing that:							     *#
#* 	- You hold the author harmless for any damage this program may cause *#
#*      - You  charge  no fee  for use,  distribution,  work,  installation, *#
#*	    customization or anything that is related to this program or its *#
#*	    derivates.							     *#
#*	- This notice is always included as-is,  with no change of any kind, *#
#*	   in any distribution, extract or any human-readable form.          *#
#*	- Any modification you brought to this  program is commented as one, *#
#*	   and signed.							     *#
#*	- The name of  Patrick Nguyen  may  be used to  neither endorse  nor *#
#*	   promote  products derived  from this software  without  specific  *#
#*	   prior  written permission.					     *#
#*									     *#
#* Please note that I, as the author, may change the program without adding  *#
#* any comment or notice.						     *#
#* This  program is  distributed  in the  hope that it will be useful,  but  *#
#* without  any  warrantee or  guarantee  of  any  kind,  neither  explicit  *#
#* nor implied, not even this of merchantability and use.		     *#
#*					Patrick Nguyen.			     *#
#* My address:								     *#
#*  Patrick Nguyen							     *#
#*  7, ch. de la Goumoenche						     *#
#*  CH-1027 Lonay ( Switzerland )					     *#
#* or pnguyen@elde.epfl.ch if you're inet.				     *#
#*****************************************************************************#
# ACKNOWLEDGEMENTS:
#  This script is heavily based on a shell script written by Hermann Dunkel
# <hedu@cul-ipn.uni-kiel.de>, itself based on a logfile by Jens Claussen
# <claussen@db.fmi.uni-passau.de>. An updated version by myself can be found
# in the package wxWin_shlib, which you should find at your favorite linux
# site.
#
# the initials `mf' should hereinafter refer as me (MegaFork).
#
#--------------------------------------------------------
# editable variables
# ~~~~~~~~~~~~~~~~~~
# The basename for the library:
$NAME="gmp";

# Version:
# suffix for the shared lib
$VERSION="1.3.2";

# Where should the library be installed?
$DEST_DIR="/usr/local/lib";

# X11 support: do we need that?
$NEED_X11=0;
# define this if you need X11
$X11_DIR="/usr/X11R6";

# Additionnal libraries (to be passed to the linker).
$ADD_LIBS="";

#use whatever value your favorite shlib tables maintainer told you
# Address:
$ADDR="0x67000000";
# J_SIZE: seems reasonable to me -mf
$J_SIZE="0x4000";
# G_SIZE: seems reasonable to me -mf
$G_SIZE="0x2000";

# Compiler:
# (would anyone use cc anyway?)
# Add --version if you wish..	-mf
$CC="gcc";

# Leave this as is if you don't know
$ROOTDIR=qx{ pwd };
chop($ROOTDIR);

#-------------------------------- end of editable area

# First, check out the table_description to see whether we are attempting to
# override a shlib.
check_address();

# Set the jump directory (where the jump tables shall reside
$JUMP_DIR="$ROOTDIR/jump";
$JUMP_LIB="lib$NAME";
# Setting environnement variables, for use of the dll tools
$ENV{JUMP_DIR}=$JUMP_DIR;
$ENV{JUMP_LIB}=$JUMP_LIB;

# The shared libraries specific options that should be passed to `make'.
$SHOPT="CC=\"$CC -O6 -m486 -funroll-loops -D_LINUX_DLL -B/usr/dll/jump/\"";

# add /usr/dll/bin to our path
$ENV{PATH}="/usr/dll/bin:$ENV{PATH}";

# if the jump directory doesn't exist, create it
if (! -d $JUMP_DIR) {
	mkdir($JUMP_DIR, 0755);
}
chdir("$JUMP_DIR");

print "ROOTDIR=$ROOTDIR\n";
print "JUMP_DIR=$JUMP_DIR JUMP_LIB=$JUMP_LIB\n";

if (! -d "/usr/dll/bin") {
	print "Could not find /usr/dll/bin!\n";
	print "Is tools-2.x x>=11 installed ?\n";
	exit 1;
}

#
# find the existing libs ...
#
$LIB_C="/usr/lib/libc.sa";
$LIB_M="/usr/lib/libm.sa";

if ($NEED_X11) {
  $LIB_X11="/usr/lib/libX11.sa";
  $LIB_XT="/usr/lib/libXt.sa";

  if (! -f $LIB_X11) {
	$LIB_X11="$X11_DIR/lib/libX11.sa";
  }
  if (! -f $LIB_X11) {
	die "Could not find libX11.sa";
  }
  if (! -f $LIB_XT) {
	$LIB_XT="$X11_DIR/lib/libXt.sa";
  }
  if (! -f $LIB_XT) {
	die "Could not find libXt.sa";
  }
  print "X11: using $LIB_X11 and $LIB_XT\n";
}

print "Using $LIB_C $LIB_M\n";

chop($LIB_GCC=qx{ find /usr/lib/gcc-lib -name '2.*' -print});

die "Could not find libgcc!" unless length($LIB_GCC)!=0;
print "LIB_GCC is $LIB_GCC\n";

#
print "The following files are in JUMP_DIR:\n";
system("ls -aC");
print "Press RETURN to continue\n";
<>;

$laststage="";

for(;;) {
   local $cmd;
   chdir($ROOTDIR);
   print "q)uit\n";
   print "l)ist files in JUMP_DIR cj) clean jumpdir cl) clean lib* cs) clean *.s\n\n";
   print "1) compile stage 1: make clean; make\n";
   print "1a)retry   stage 1: make\n";
   print "2) build jump.import\n";
   print "3) compile stage 2: make clean; make\n";
   print "3a)retry   stage 2: make\n";
   print "4) build shared library\n";
   print "5) install in $DEST_DIR/\n";
   print "\nlaststage was: $laststage\n";

   $_=<>;
   $cmd=$_;
   SWITCH: {
    if (/^cs\n/) { system("rm -f *.s");
		 print "In JUMP_DIR are:\n";
		 system("ls -aC $JUMP_DIR");
		 last SWITCH;
    }
    if (/^cl\n/) { system("rm -f $JUMP_DIR/*");
		 print "In JUMP_DIR are:\n";
		 system("ls -aC $JUMP_DIR");
		 last SWITCH;
    }
    if (/^cj\n/) { system("rm -f $JUMP_DIR/*");
		 print "In JUMP_DIR are:\n";
		 system("ls -aC $JUMP_DIR/");
		 last SWITCH;
    }
    if (/^l\n/)  { print "In JUMP_DIR are:\n";
		 system("ls -aC $JUMP_DIR");
		 last SWITCH;
    }
    if (/^1\n/)  { system("pwd");
	print "compile stage 1, logged to make.log\n" ;
	system("make clean");
	system("make $SHOPT all 2>&1 | tee make.log");
	system("less make.log");
	last SWITCH;
    }
    if (/^1a\n/) {
	print "compile stage 1, retry, logged to make.log\n";
        system("make $SHOPT all 2>&1 | tee make.log");
	system("less make.log");
	last SWITCH;
    }
    if (/^2\n/) {
	chdir($JUMP_DIR);
	print "generating list of imported/ignored Symbols (jump.import)\n";
	system("getvars");
	system("getfuncs");
	print "$LIB_C\n";
	system("nm --no-cplus -o $LIB_C |grep __GOT_ | sed 's/__GOT_/_/' >jump.import");
	if ($NEED_X) {
	print "$LIB_X\n";
        system("nm --no-cplus -o $LIB_X |grep __GOT_ | sed 's/__GOT_/_/' >>jump.import");
	print "$LIB_XT\n";
        system("nm --no-cplus -o $LIB_XT |grep __GOT_ | sed 's/__GOT_/_/' >>jump.import");
	}
        print "$LIB_M\n";
        system("nm --no-cplus -o $LIB_M |grep __GOT_ | sed 's/__GOT_/_/' >>jump.import");
	last SWITCH;
    }
    if (/^3\n/) {
	print "compile stage 2: make clean;make\n";
        system("make clean");
        system("make $SHOPT ) 2>&1 | tee make.log");
	system("less make.log");
	last SWITCH;
    }
    if (/^3a\n/) {
	print "retry stage 2: make\n";
        system("make $SHOPT 2>&1 | tee make.log");
	system("less make.log");
	last SWITCH;
    }
    if (/^4\n/) {
	local $MAGIC_NUM;
	chdir($JUMP_DIR);
	print "mkimage\n";
        # getsize, build the image and lib
	system("getsize >jump.vars-new");
	system("mv -f jump.vars jump.vars-old");
	system("mv jump.vars-new jump.vars");
	# create image and stubs
	$MAGIC_NUM="-v $VERSION -a $ADDR -g $G_SIZE -j $J_SIZE";
	if( $NEED_X ) {
	    system("mkimage -f -l $JUMP_LIB $MAGIC_NUM -- -L$LIB_GCC -L$X11_DIR/lib $ROOTDIR/$JUMP_LIB.a $ADD_LIBS -lXt -lX11 -lg++ -lm -lgcc -lc");
	} else {
	    system("mkimage -f -l $JUMP_LIB $MAGIC_NUM -- -L$LIB_GCC $ROOTDIR/$JUMP_LIB.a $ADD_LIBS -lg++ -lm -lgcc -lc 2>&1 |less");
	}
	system("mkstubs -l $JUMP_LIB $MAGIC_NUM -- $JUMP_LIB");
	last SWITCH;
    }
    if (/^5\n/) {
	chdir($JUMP_DIR);
	print "Installing in $DEST_DIR (using mv)\n";
	system("mv $JUMP_LIB.so.$VERSION $DEST_DIR");
	system("mv $JUMP_LIB.sa $DEST_DIR");
	system("ldconfig -n $DEST_DIR");
	last SWITCH;
    }
    if (/^q/) {
	print "Goodbye\n";
	exit 0;
    }
    print "wrong command";
    $cmd=$laststage; # save last stage
    last SWITCH;
  } # SWITCH
  $laststage=$cmd
} #main loop

# check_address: find out whether the address is already used, or the
# official library resides in another address.
# We should check /etc/ld.so.conf
sub check_address {
  local $libname = "";
  local $addr = 0;
  local $end = 0;
  local $my_addr = hex($ADDR);
  local $my_end = $my_addr + hex($G_SIZE) + hex($J_SIZE);
  local $my_libname = "lib$NAME.so";

  open( TABLE_DESCRIPTION, "grep -v ^# /usr/dll/table_description|" );

  while( <TABLE_DESCRIPTION> ) {
     chop;
     SWITCH: {
        if (s/^Library://) {
		if( $addr != 0 ) {
		  # do we have the same name?
		  if( index($my_libname, $libname) != -1 ) {
			print "Found library in description table!\n";
			if( $addr == $my_addr ) {
			   print "Same starting address...\n";
			} else {
			   print "Address does not match!\n";
			   print "Wanted $my_addr, got $addr.\n";
			}
			if ($end == $my_end) {
			   print "Same end address...\n";
			} else {
			   print "Ending addresses do not match!\n";
			   print "Wanted $my_end, $end.\n";
			}
		  } elsif ( not (
			(($my_addr < $addr) and ($my_end < $addr)) or
			(($my_addr > $end ) and ($my_end > $end ))
		       )) {
		     print "Warning!! Possible conflict with $libname!\n";
		  }
		}
		$libname=$_;
                last SWITCH;
        }
        if (s/^Start://) {
		$addr=hex($_);
        }
        if (s/^End//) {
		$end=hex($_);
                last SWITCH;
        }
     } #  SWITCH
  }    #  while
}      #  find_collision

