
#ifndef _iterator_h
#define _iterator_h 1

#include <setjmp.h>
#include <stdio.h>
#include <memory.h>
#ifdef __mips__
#define SAVE_SP(osp) asm("move %0, $sp" :"=r" (osp) : "r" (osp))
#define SET_SP(osp)  asm("move $sp, %0" : : "r" (osp))
#endif
#ifdef __sparc__
/* #define SAVE_SP(osp) asm("mov %%sp,%0" :"=r" (osp) : "r" (osp))
#define SET_SP(osp)  asm("mov %0,%%sp" : : "r" (osp)) */
#define SAVE_SP(osp)
#define SET_SP(osp)
#endif
const __in_iterator_f_ = 0;
extern "C" typeof(setjmp) _setjmp;
extern "C" typeof(longjmp) _longjmp;
#define _ITER_BR -1
#ifdef __sparc_setjmp_h
/* need index for sp in jmp_buf */
#define JB_SP 2
#endif
struct iter_struct
{
  int val;
  int empty;
  int firstcall;
  int *adv_done; // reference to advance flaG
  char * orig_sp;
  char * iter_sp;
  // iter_struct() { empty = 0; }
  jmp_buf caller_buf; /* caller's jmp_buf */
  jmp_buf iter_buf;   /* iterator fct jmp_buf */
  ;

};

// macro versions of the iterator struct member functions.
#define ITER_INIT(this) ( _setjmp((this)->iter_buf))
#define  ITER_YIELD(this) \
(  { int sjrc;\
    if ((sjrc= _setjmp((this)->iter_buf))==0) \
    {  /* set saved sp to its max valueif */ \
      if ( (this)->caller_buf[JB_SP] > (this)->iter_buf[JB_SP] )\
	(this)->caller_buf[JB_SP] = (this)->iter_buf[JB_SP];\
      _longjmp((this)->caller_buf,1); \
    }\
    sjrc;\
})

#define  ITER_FINAL(this) ({ (this)->empty = 1; _longjmp((this)->caller_buf,1); })
  // functions called from caller of iterator 
#define CALL_ITER(this) \
  ({ \
    if (!(this)->empty && (_setjmp((this)->caller_buf))==0) \
    {  /* set saved sp to its max valueif */ \
      if ( (this)->caller_buf[JB_SP] < (this)->iter_buf[JB_SP] )\
	(this)->iter_buf[JB_SP] = (this)->caller_buf[JB_SP];\
      _longjmp((this)->iter_buf,1); \
    }\
  })
#define CALL_BREAK(this) \
  /* call iterator with break parm in longjmp */ \
  ({ \
    if (!(this)->empty && (_setjmp((this)->caller_buf))==0) \
    {  /* set saved sp to its max valueif */ \
      if ( (this)->caller_buf[JB_SP] < (this)->iter_buf[JB_SP] )\
	(this)->iter_buf[JB_SP] = (this)->caller_buf[JB_SP];\
      _longjmp((this)->iter_buf,_ITER_BR); \
    }\
  })

template <class t> class iterator : public iter_struct
// struct iterator_int : public iter_struct
{
public:
  t * rpt;
  void caller_init(t * ret, char *osp) 
  { orig_sp = osp; rpt = ret; firstcall=1; empty = 0;}
  // iterator (t &rval) { rpt = &rval;};
  // int *rpt;
  // iterator_int (int  &rval) { rpt = &rval;};
};


// #define ITER_DECL(type, fargs) iterator<type> f args return ictl;

#define ITERATE_INIT(type,name,fctcall,advpt) \
  type name; \
  iterator<type> name ## ictl; \
  name ## ictl.caller_init(&name,osp); \
  name ## ictl.adv_done = advpt; \
  if (_setjmp(name ## ictl.caller_buf) == 0) name ## ictl = fctcall;
#define ITERATE_PROLOGUE \
  char *osp; \
  char *ospace = (char *)alloca(4);\
  int __itadv_done = 1;\
  if (!__in_iterator_f_) SAVE_SP(osp); /* asm("move %0, $sp" :"=r" (osp) : "r" (osp)); */ 
#define ITERATE_EPILOGUE \
  /* should restore sp here maybe ,also check for empty */ \
  if (!__in_iterator_f_) SET_SP(osp); /* asm("move $sp, %0" : : "r" (osp));  */ 
#define ITERATE(type,name,fctcall, stmt)  { \
  ITERATE_PROLOGUE \
  ITERATE_INIT(type,name,fctcall,&__itadv_done) \
  while (1)  { \
    if (!__itadv_done) { CALL_ITER(&name ## ictl); } \
    __itadv_done = 0; \
    if (name##ictl.empty) break; \
    stmt; \
    name##_inext: ; \
  } \
  ITERATE_EPILOGUE \
}

#define ITERATE2(type,name,fctcall,type2,name2,fctcall2, stmt)  { \
  ITERATE_PROLOGUE \
  ITERATE_INIT(type,name,fctcall,&__itadv_done) \
  ITERATE_INIT(type2,name2,fctcall2, &__itadv_done) \
  while (1)  { \
    if (!__itadv_done) { CALL_ITER(&name ## ictl);CALL_ITER(&name2 ## ictl);} \
    __itadv_done = 0; \
    if (name##ictl.empty && name2##ictl.empty) break; \
    stmt; \
    name##_inext: ; \
  } \
  ITERATE_EPILOGUE \
}
#define ITERATE3(type,name,fctcall,type2,name2,fctcall2, type3,name3,fctcall3, stmt)  { \
  ITERATE_PROLOGUE \
  ITERATE_INIT(type,name,fctcall,&__itadv_done) \
  ITERATE_INIT(type2,name2,fctcall2, &__itadv_done) \
  ITERATE_INIT(type3,name3,fctcall3, &__itadv_done) \
  while (1)  { \
    if (!__itadv_done) { CALL_ITER(&name ## ictl); \
    CALL_ITER(&name2 ## ictl); \
    CALL_ITER(&name3 ## ictl);} \
    __itadv_done = 0; \
    if (name##ictl.empty && name2##ictl.empty && name3##ictl.empty) break; \
    stmt; \
    name##_inext: ; \
  } \
  ITERATE_EPILOGUE \
}

#define ITERATE4(type,name,fctcall,type2,name2,fctcall2, type3,name3,fctcall3, type4,name4,fctcall4, stmt)  { \
  ITERATE_PROLOGUE \
  ITERATE_INIT(type,name,fctcall,&__itadv_done) \
  ITERATE_INIT(type2,name2,fctcall2, &__itadv_done) \
  ITERATE_INIT(type3,name3,fctcall3, &__itadv_done) \
  ITERATE_INIT(type4,name4,fctcall4, &__itadv_done) \
  while (1)  { \
    if (!__itadv_done) { CALL_ITER(&name ## ictl); \
    CALL_ITER(&name2 ## ictl); \
    CALL_ITER(&name3 ## ictl); \
    CALL_ITER(&name4 ## ictl);} \
    __itadv_done = 0; \
    if (name##ictl.empty && name2##ictl.empty && name3##ictl.empty && name4##iclt.empty) break; \
    stmt; \
    name##_inext: ; \
  } \
  ITERATE_EPILOGUE \
}


#define YIELD(x) \
({ *ictl.rpt = (x); if(ITER_YIELD(&ictl)==_ITER_BR) goto __iter_end__;})
#define YIELD_BREAK(x,bstmt) \
({ *ictl.rpt = (x); if(ITER_YIELD(&ictl)==_ITER_BR) { bstmt; goto __iter_end__;}})
// return final value
#define RETURN(x) ({ YIELD(x); goto __iter_end__;})
#define IRETURN ({ goto __iter_end__;})
#define ADVANCE(x) ({ \
CALL_ITER(&x##ictl); *x##ictl.adv_done = 1; \
})
#define ADVANCE2(x,y) ({ \
CALL_ITER(&x##ictl); *x##ictl.adv_done = 1; \
CALL_ITER(&y##ictl); *y##ictl.adv_done = 1; \
})
#define ADVANCE3(x,y,z) ({ \
CALL_ITER(&x##ictl); *x##ictl.adv_done = 1; \
CALL_ITER(&y##ictl); *y##ictl.adv_done = 1; \
CALL_ITER(&z##ictl); *z##ictl.adv_done = 1; \
})
#define ADVANCE4(x,y,z,t) ({ \
CALL_ITER(&x##ictl); *x##ictl.adv_done = 1; \
CALL_ITER(&y##ictl); *y##ictl.adv_done = 1; \
CALL_ITER(&z##ictl); *z##ictl.adv_done = 1; \
CALL_ITER(&t##ictl); *t##ictl.adv_done = 1; \
})
#define BREAK(x) ({ \
CALL_BREAK(&x##ictl); \
goto x##_inext;})
#define BREAK2(x,y) ({ \
CALL_BREAK(&x##ictl); \
CALL_BREAK(&y##ictl); \
goto x##_inext;})
#define BREAK3(x,y,z) ({ \
CALL_BREAK(&x##ictl); \
CALL_BREAK(&y##ictl); \
CALL_BREAK(&z##ictl); \
goto x##_inext;})
#define BREAK4(x,y,z,t) ({ \
CALL_BREAK(&x##ictl); \
CALL_BREAK(&y##ictl); \
CALL_BREAK(&z##ictl); \
CALL_BREAK(&t##ictl); \
goto x##_inext;})


#define ITER_DECL(type, fname_args) \
iterator<type>  fname_args 
#define ITER_DEF(type, fname_args) \
ITER_DECL(type,fname_args); \
iterator<type>  fname_args return ictl; \
{ const int __in_iterator_f_ = 1; ITER_INIT(&ictl);
#define END_ITER_DEF __iter_end__: ITER_FINAL(&ictl); }

#endif
