template
<
	dbclass	keyType,
	dbclass	entityType
>
dbclass binaryTreeNode 
 {
	keyType			nodeKey;
	entityType			*entPtr;
	binaryTreeNode		*leftChild;
	binaryTreeNode		*rightChild;
public:
	binaryTreeNode( keyType insertKey, entityType * insertPtr ) {
		nodeKey = insertKey;
		entPtr = insertPtr;
		leftChild = rightChild = NULL;
	}
	void insert( binaryTreeNode * newNode ) {
		int cmp = compare( &(newNode->nodeKey), &nodeKey );
		if( cmp <= 0 )
			if( leftChild == NULL )
				leftChild = newNode;
			else
				leftChild->insert( newNode );
		else
			if( rightChild == NULL )
				rightChild = newNode;
			else
				rightChild->insert( newNode );
	}
	ITER_DECL(entityType *, search(keyType));
};

