

// persistent data and support functions

#include "data.h"


// persistent objects for the database

persistent accountFile accounts;
persistent historyFile history;
persistent tellerFile  tellers;
persistent branchFile  branches;
persistent dbint    xtime = 0;


// support functions for hashed account file

int accountMatch(dbint& accountNo, account& accountRec)
{
    return (accountNo - accountRec.accountNo);
};

int accountHash(dbint& accountNo)
{
    return (accountNo % accountSize);
};


// support functions for hashed teller file

int tellerMatch(dbint& tellerNo, teller& tellerRec)
{
    return (tellerNo - tellerRec.tellerNo);
};

int tellerHash(dbint& tellerNo)
{
    return (tellerNo % tellerSize);
};


// support functions for hashed branch file

int branchMatch(dbint& branchNo, branch& branchRec)
{
    return (branchNo - branchRec.branchNo);
};

int branchHash(dbint& branchNo)
{
    return (branchNo % branchSize);
};

