#include <E/sm_if.h>
#include <E/_E_file.h>
// define types needed for the toy database

#include "hashFile.h"


// hash table sizes for hashed files

const int accountSize = 10;
const int tellerSize  = 10;
const int branchSize  = 10;


// record types for files

dbstruct account {
    dbint   accountNo;
    dbint   branchNo;
    dbint   balance;
};

dbstruct teller {
    dbint   tellerNo;
    dbint   balance;
};

dbstruct branch {
    dbint   branchNo;
    dbint   balance;
};

dbstruct historyRec {
    dbint   time;
    dbint   accountNo;
    dbint   tellerNo;
    dbint   delta;
    dbint   newBalance;
};

// support function signatures needed for hashed files

extern int accountMatch(dbint&, account&);
extern int accountHash(dbint&);
extern int tellerMatch(dbint&, teller&);
extern int tellerHash(dbint&);
extern int branchMatch(dbint&, branch&);
extern int branchHash(dbint&);

// tupes for hashed and regular files

#ifdef olddef
dbclass accountFile:
           hashFile[dbint, account, accountMatch, accountHash, accountSize];
dbclass tellerFile:
           hashFile[dbint, teller, tellerMatch, tellerHash, tellerSize];
dbclass branchFile:
           hashFile[dbint, branch, branchMatch, branchHash, branchSize];
dbclass historyFile:
           collection[historyRec];
#endif

typedef collection<historyRec> historyFile;
typedef hashFile<dbint,account,accountSize>  accountFile;
typedef hashFile<dbint,teller,tellerSize>  tellerFile;
typedef hashFile<dbint,branch,branchSize>  branchFile;
// typedef collection<historyRec> historyFile;
extern historyRec * gethistory();
