.ds V "3.1
.TH Installation 1 
.SH NAME
Installation \- EXODUS Storage Manager \*V Installation Manual
.SH DESCRIPTION
This document tells how to get a copy of the EXODUS
Storage Manager source and install it on your system.
.SH "GETTING THE SOFTWARE"
The Exodus Storage Manager is available without charge
by anonymous FTP from
.BR ftp.cs.wisc.edu.
All of the Exodus software is located in the
.BR exodus
directory.  The Storage Manager sources, documentation, and
test programs are available in:
.BR "sm/sm.src.\*V.tar.Z"
.PP
To eliminate the need to compile the Storage Manager, we provide libraries
for SPARCstations/SUN-OS, HP 7xx/HP-UX,  and DECstations/ULTRIX in
.BR "sm.sparc.\*V.tar.Z",
.BR "sm.hp.\*V.tar.Z"
and
.BR "sm.dec.\*V.tar.Z",
respectively.  
The instructions below describe how to un-tar the release and
install the Storage Manager by building binaries from the libraries
provided.  
We also include instructions for compiling the Storage
Manager for those who wish to do so.  
.SH "PREREQUISITES"
.PP
The Storage Manager uses \fBSystem V shared memory\fR and semaphores,
so your kernel must have them installed.  The kernel should support a
shared memory segment of at least 4 megabytes.  If you do not know if
your system is configured with shared memory, see your system
administrator.  If you try to run the  Storage Manager server on a
system that does not have shared memory, the server will print an
extensive message about its failure to allocate shared memory, and it
will tell you how much shared memory it was trying to acquire;  then it
will exit.  The amount of shared memory needed is based on the server
buffer pool size option called bufpages.  See the user guide for
instructions on setting options.
.PP
The Storage Manager is written in C++, and is made with \fBGNU C++\fR
(g++ version 2.4.5 (we have also made it with 2.3.3 in the past)), so
\fBg++ must be available on your system to install the SM\fR.  The
Storage Manager's client application library has a C interface, so
applications can be written in C or C++.  If you wish to use the client
library (\fClibsm_client.a\fR) we provide, you must link applications
with g++ (or eg++, the Exodus E compiler, an extension of g++).
.PP
Because the include files for the various C++ compilers
differ, and in many cases are site-dependent, 
you may encounter some compilation problems due to differences in 
include files and their locations.  
These can usually be resolved with minor changes to the code.
If you have problems with compiling because certain system
include files cannot be found, see your system administrator.
Some system include files (particularly network-related ones)
are not included with the standard compiler and library releases,
and your system administrator might have to install them for you.
.SH "DISK REQUIREMENTS"
.PP
The compressed tar file for the source release
(\fCsm.src.\*V.tar.Z\fR)
is about 2.5 megabytes.
The uncompressed tar file for the source release
(\fCsm.src.\*V.tar\fR)
is about 8.4 megabytes.
.PP
The table below lists the minimum
disk requirements for making a Storage Manager
(compilation and linking), and for the installed files.
It includes the doc/ and tests/ directories.
These figures are approximate.
.PP
.TS
center tab(+);
c c c 
c n n.
Architecture+everything installed but tests+binaries & libraries only
_
MIPS (DECstations)+13 Megabytes+3.2 Megabytes
SPARCstations +11.5 Megabytes+2.5 Megabytes
HP 7xx +24 Megabytes+5.7 Megabytes
.TE
.SH "PRELIMINARIES"
.PP
If the Storage Manager is to be used by multiple users, we
recommend (but do not require) creating a user and account
for the Storage Manager.  For the purpose of this discussion,
we call the account
.BR exodus ,
but you can give it any name you please.  
All files created by the Storage Manager's volume formatting 
program will be owned by the user who runs it 
and will be given permission bits 0604 (user read and write
permissions, public read permission).  
If raw disk partitions are to be used with  the Storage Manager, 
they must be mounted so that the Storage Manager can read and write them.
.PP
Normally, the Storage Manager listens on a port, named in 
\fC/etc/services\fR, for client messages.  
The default name of this port is "exodussm".   
Clients, by default, also look up this port in \fC/etc/services\fR.  
Therefore, we suggest installing in \fC/etc/services\fR an
entry such as:
.EX
exodussm  1152/tcp     #exodus Storage Manager
.EE
\fBNote\fR: You do not need to install this port name now.  The SM can 
run without it as long as certain options are set correctly.  The
examples in the tests/ directory show how to set these options.
More information on \fC/etc/services\fR can be found by reading "man
services".  More information on the server's port usage, including
alternative ports, can be found in section 5.2 of the user guide.
.PP
.SH "INSTALLING THE STORAGE MANAGER"
.IP "Create" 10
the directory in which to un-tar the release.
For the purpose of this discussion, call it \fCSMROOT\fR.
.IP "Extract" 10
the sources from the tar file.
Perhaps you haven't got enough disk space on one disk to put
both the source tar file and the extracted sources in the same
directory, so we assume that you put the tar file in /tmp:
.EX
cd SMROOT
zcat /tmp/sm.src.\*V.tar.Z | tar -xvf - 
.EE
.IP
The source release contains the following directories: 
src, doc, tests, include, lib, and bin.
The src directory contains the Storage Manager source code.  
The doc directory contains documentation on installing and using the Storage Manager.  
The tests directory contains test and example programs.  
The include, lib and bin directories are shell directories in the source release.
After you install an object release (from \fCsm.\fI<machine>\fC.\*V.tar.Z\fR),
the include directory will contain an include file that your applications
use,
the lib directory will contain the libraries from which you built
your executables, 
The doc and tests directories contain "README" files that give information about their contents.
.IP
The libraries we distribute are not complete because there
are configuration options and extra functions that 
some users may wish to include.  
The client library (\fClibsm_client.a\fR),
and the server (sm_server) must be built from the libraries contained in the release.
There are four steps to install the libraries and build the binaries.
The first is to un-tar the object release file:
.EX
cd SMROOT
zcat /tmp/sm.\fI<machine>\fC.\*V.tar.Z | tar -xvf - 
.EE
.IP
The second step is to edit the file \fCSMROOT/src/config/configOptions.c\fR
to indicate the location of your site's default configuration
files and the location of the disk I/O program used by the server.
See the comments in configOptions.c for instructions on what to change.
As you learn more about the Storage Manager, you may wish to establish 
a configuration file that is used by everyone at your site.  
If so, src/config/configOptions.c will need to be updated 
and the final step (below) repeated.
.IP
The third step is to set up a few things for your compiler.
If your C++ compiler is not called "g++" you need to change 
src/makefile.options
to use the proper names.  
The variables to change are CC and CPLUSPLUS located at the bottom of the file.  
The system can also be installed with the E compiler we distribute.
By default, the E compiler attempts to link in \fClibsm_client.a\fR (since
E programs usually require persistence), but this can cause
problems at the link stage of installing or compiling the Storage
Manager.  
Before using E for this purpose, you need to set an environment variable as follows:
.EX
setenv SM_CLIENT_LIB 
.EE
.IP
Once the compiler issues have been settled, the fourth and final step is to make
the binaries:
.EX
cd SMROOT/src
make binary_install
.EE
.IP
This will generate \fCbin/sm_server\fR and \fClib/libsm_client.a\fR.
Note, you may see warnings from "make" concerning "multiple rules" or
"too many command lines".  These messages can be ignored.
.IP
The user guide, "Using the EXODUS Storage Manager," refers to this 
installation guide for the locations of the files needed to 
run the Storage Manager.  
Here is the list of files and their location in the release:
.EX
libsm_client.a:	SMROOT/lib
sm_client.h:		SMROOT/include
sm_server:		SMROOT/bin
formatvol:		SMROOT/bin
shutserver:		SMROOT/bin
diskrw:		SMROOT/bin
producer/consumer example:  SMROOT/tests/producer_consumer
.EE
.IP
The tests that are included with the release refer to binaries and libraries in the
\fCSMROOT/bin/, SMROOT/lib/, \fRand\fC SMROOT/include/\fR
directories.
Once you have a working Storage Manager, you can
copy or move the contents of these directories
to their final destinations.
.IP "Print" 10
the documentation.
See the README in the \fCSMROOT/doc\fR directory for instructions.  
.IP "Test" 10
the binary versions of the Storage Manager.
.EX
cd SMROOT/tests
more README
.EE
.IP
In \fCSMROOT/tests\fR are tests and example programs.
The README tells you how to run the tests.
If the tests are successful, you are done.
If the binaries you install do not work on your machine, check the 
prerequisites, above.
If your system meets all the prerequisites,
you may want to try making a Storage Manager from scratch.
.SH "COMPILING THE STORAGE MANAGER"
.PP
As distributed,
the makefiles will compile the entire system with g++.
If wish to use E, remember to set the SM_CLIENT_LIB environment
variable to null (as described in the installation instructions above),
to avoid having E link in its version of \fClibsm_client.a\fR.
.PP
If you use a compiler other than g++, you must determine if
the compiler understands the keyword
.B volatile.
Synchronization of the server processes
uses the Silberschatz & Peterson algorithm #4 
(p. 88, Operating System Concepts, Alternate Edition, Addison-Wesley, 1988),
which relies on the 
.B volatile
storage class.
There are two ways to make
the few files that implement the synchronization primitives.
.IP "Volatile works" 10
If your C++ compiler understands and properly handles
.B volatile,
(or if it does not optimize away the references to the volatile data,
even if the keyword
.B volatile
does not appear), 
and your C++ passes the
keyword along to its underlying C compiler,
the entire system can be made with C++ without changes
to any source code.
.IP "Volatile does not work" 10
Your C++ compiler does not handle 
.B volatile,
(it optimizes the memory references away).
If your machine has a test-and-set instruction (e.g.,SPARC),
an alternative synchronization algorithm is used.
The system is compiled with C++ and with -DTESTANDSET.
If you are porting the Storage Manager to a new architecture,
you will have to write a test-and-set function
(see \fCSMROOT/src/serverlib/disk/testandset.S\fR).
.PP
The determination is made by make(1)
on the basis of the macros
CPLUSPLUS (found in \fCSMROOT/makefile.options\fR),
HOSTTYPE  (defined by make on some architectures)
and 
CPUTYPE  (defined by make on other architectures).
You must not redefine HOSTTYPE or CPUTYPE when you make a Storage Manager.
.PP
Be sure that your shell limits are high or unlimited (see csh(1)).
To run build the Storage Manager, do
.EX
cd SMROOT/src
make install
.EE
.PP
This will install the binaries in \fCSMROOT/{bin,lib}\fR.
More information on making the Storage Manager is available in 
\fCSMROOT/doc/Makefiles.man\fR.
Tests can then be run as described above.
.SH "BROWSING THE STORAGE MANAGER SOURCE"
.PP
The Storage Manager source is in 
\fCSMROOT/src\fR.
General information on the Storage Manager source is available in
\fCSMROOT/doc/source.man\fR. 
Information on the Storage Manager's architecture is available in 
\fCSMROOT/doc/arch_overview.me\fR.
If you wish to browse the source using tags you must first make the tags files by running
.EX
make tags
.EE
in the \fCSMROOT/src\fR directory.
Also, put in your 
\fC~/.exrc\fR the following:
.EX
set tags=./tags\ ./tags.all
.EE

.SH SEE ALSO
Makefiles \- making an Exodus Storage Manager
