.nr 99 0 1
.TH workspace 1 
.SH NAME
workspace \- making an Exodus Storage Manager workspace
.SH DESCRIPTION
NB: All the makes here are verbose.
If you want to limit the output of make,
see 
Makefile \- making an Exodus Storage Manager.
.PP
.IP "\n+(99" 5
Your environment variable BASELINE must be the baseline's absolute path.
.EX
	cd baseline
	setenv BASELINE `pwd`
.EE
.IP "\n+(99" 5
Create a directory for your workspace.
It can have any name; for this discussion, we call it 
.q WORKSPACE.
.EX
	mkdir WORKSPACE
.EE
.IP "\n+(99" 5
Go to the workspace directory and get its make files:
.EX
	cd WORKSPACE
	co $BASELINE/src/RCS/[Mm]akefile*,v
.EE
This checks out, among other things, 
.BR Makefile .
All Makefiles include a 
.BR makefile.depend ,
which
should not exist in the RCS directories,
so the now you have to do
.EX
	touch makefile.depend
.EE
The makefiles rely on being able to change makefile.depend,
so if a makefile.depend was in the RCS directory and got
checked out, you must make it writable in your workspace.
.IP
The default Makefile will put 
.I everything 
in your workspace.
If that suits you, skip the next step.
.IP "\n+(99" 5
If you want some modules to come from the baseline, do
.EX
	make [-e -s] workspace.1level
	vi makefile 
	...
.EE
This creates all the first-level subdirectories and
makes a writable copy of 
.B Makefile
in 
.B makefile
in the top-level and each first-level directory.
.EX
	vi makefile 
	...
.EE
Edit the macros MOD_WORKSPACE and MOD_BASELINE in each
makefile, according to your wishes.
If you want only part of a module (e.g., client/bf) in your workspace,
put the parent of the part that you want (e.g., client) in your workspace. 
Modules listed in MOD_BASELINE will be taken in their entirety from 
the baseline.
.IP "\n+(99" 5
Go back to the root of the workspace:
.EX
	cd WORKSPACE
	make [-s -e] workspace
.EE
.IP "\n+(99" 5
If everything is in your workspace, skip this step.
If anything comes from the baseline, do
.EX
	cd WORKSPACE
	make [-s -e] getbaselineparts
.EE
.IP "\n+(99" 5
Still in the root of the workspace, make dependencies:
.EX
	make [-s -e] depend
.EE
.IP "\n+(99" 5
Still in the root of the workspace, make tags:
.EX
	make [-s -e] tags
.EE
Now you have a pair of links (tags.all, tags.baseline) in each directory.
.BR "Tags.all"
points to the tags file for its module (e.g. tags.all in 
client/* point to client/tags).
.BR "Tags.baseline" 
points to the baseline's tags file for the module
(e.g. tags.baseline in client/* point to $BASELINE/src/client/tags.
.IP "\n+(99" 5
To use the tags files made in the previous step,
add to your ~/.exrc the following line:
.EX
	set tags=tags\\ tags.all\\ tags.baseline
.EE
.IP "\n+(99" 5
If you want to eliminate duplicate tags files in the subdirectories,
do
.EX
	make [-s -e] tags.clean
.EE
.LP
Now you have a workspace with the appropriate sources and 
baseline products.
To make a server in the workspace, see
.BR "Makefile \- making an Exodus Storage Manager" .
.SH "MAKE OPTIONS"
.IP "Silent Makes:" 15
You have several ways to limit the output of the makes.
You can use the -s option, to prevent Make from printing each
command it executes.
(See make(1).)
.IP
You can set your environment variable LOCK to "-q"
and use the "-e" option with Make, to make the rcs functions like
co and ci quiet.
(See co(1), ci(1), rcs(1).)
.IP "Partial Makes:" 15
You can work on a portion of the storage manager code without
having to make the entire storage manager, or having to 
copy the source for the entire storage manager.
This is useful when you are working on a workstation
that has little available disk space, and want to mount most
of the source from another machine.
It is also useful when several people are working on the code at once.
A stable "baseline" copy is kept on a server machine.
Each programmer has his own "workspace".
The Makefiles have macros that specify which modules of the
storage manager are in you workspace, and which are taken from the
baseline.
Modules taken from the baseline are taken in object or executable form.
Thing in your workspace are made from a copy of the source.
.IP "Adding a module to the baseline or workspace:" 15
You can remove modules entirely and remake them.
For example, 
.EX
	cd WORKSPACE
	rm -rf client
.EE
Now you can remake the client module, either in the workspace or from
the baseline, regardless of where it came from before you removed it.
If you want
.I client
in the workspace, put it in MOD_WORKSPACE, and do
.EX
	make [-s -e] workspace
.EE
If you want it from the baseline, put it in MOD_BASELINE, and do
.EX
	make getbaselineparts
		\fIor\fR
	make [-s -e] client
	cd client
	make [-s -e] getbaseline
.EE
The last two examples are equivalent.
.SH "CONFIGURATION OPTIONS"
.IP "Debugging:" 15
The storage manager can be made with several debugging options,
which can be combined.
.IP
If the DEBUG C preprocessor flag is defined (with -DDEBUG),
the storage manager includes myriad internal checks.
Some of the checks are CPU-intensive.
.IP
The -g compiler flag can be used to generate symbols 
for use with dbx(1). (See cc(1), dbx(1).)
.IP "Optimization:" 15
The -O compiler flag can be used, in the absence of -g,
to generate optimized code.
-O cannot be used with -g; -g3 is used with -g to create
optimized code with symbols.
.IP "Profiling:" 15
The storage manager can be configured to profile itself by using
compiler flags
-DPROFIL -p.
(See prof(1).)
When compiled with -DPROFIL,
the storage manager responds to the cl_MonDump() client request
by writing its profiling information to a file, and passing along
the request to all its disk processes, who do the same.
Use the environment variable PROFDIR, so that each process writes its 
profiling information in a different file.
.IP "IPC configuration options:" 15
The server and disk processes communicate in one of two ways:
with Unix-domain sockets (see socket(2)), or with
shared-memory queues.
When the storage manager is made with -DDISK_QUEUES, the 
queues are used. When DISK_QUEUES is not defined, the
processes use Unix-domain sockets.
.SH RESTRICTIONS
.PP
The client and server have some function names in common, such as
bf_ReadPage, so it is not possible to have a global tags file for
the entire storage manager.
Instead, there are separate tags files for
client modules and for server modules.
The tags files you use depend on your working directory.
Since not all of the source is in a workspace, you also need
to use tags from the baseline.
The unfortunate result is that all the tags in the tags files
have absolute path names.
This may create problems for people who mount a baseline with NFS.
.SH CAVEATS
.PP
Be sure that you don't put a module both in MOD_WORKSPACE
and MOD_BASELINE.
You will get a message  to the effect,
"Too many commands",
and you will get unpredictable results or errors  when you try to make
anything.
.PP
Some directories get their sources from other directories.
If one of these directories is in the workspace, the other must
also be.
Examples are:
.IP "btree" 5
The code for the btrees is in 
.B client/btree.
The 
.B serverlib/btree
gets its source by linking to 
.B client/btree.
.IP "disk and diskproc" 5
The 
.B disk
directory in 
.B serverlib
uses source from
.B diskproc,
and vice versa.
If 
diskproc is in the workspace, so must be serverlib/disk,
and vice versa.
.PP
When making dependencies or tags,
if old makefile.depend or tags files are around,
they must be removed or made writable.
It is best to remove the tags files.
.PP
If you move modules from the baseline to your workspace,
you must delete the modules, 
recreate them, and run "make [-s -e] workspace" in those modules.
If you move remove modules from the workspace and get them
from the baseline instead, you must delete the modules,
recreate them, and run "make getbaselineparts" at the super-directory
level, or  "make getbaseline" in each of the modules.
You also have to re-make tags and dependencies at the super-directory
level. 
.PP
If you add or delete files from a module, you can re-make tags
and dependencies at that module level only without affecting
tags or dependencies at other levels, but the other levels will
not be up-to-date with respect to your new or obsolete files.
.SH SEE ALSO
Makefiles \- making an Exodus Storage Manager
