#ifndef _LH_LOG_H_
#define _LH_LOG_H_
/*
 *	$RCSfile: LH_Log.h,v $
 *	$Revision: 1.8 $
 *	$Date: 1993/04/19 22:15:00 $
 */
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#ifndef __LH_LOG_H__
#define __LH_LOG_H__


struct LogDirPageInitData {
		ONE			rootFlag;
		SMDATATYPE	keyType;
		
		int Size()	{ return sizeof(*this); }
		};

struct LogIndexPageInitData {
		FOUR		hashVal;
		SMDATATYPE	keyType;
		ONE			ovFlag;
		
		int Size()	{ return sizeof(*this); }
		};


struct LogLhashPhysicInsertData {
		TWO			startSlot;
		TWO			numSlots;
		FOUR		length;
		char		data[1];
		
		int Size()	{ return data + length - (char*) this; }
		int Max()	{ return BTREE_PAGESIZE - (data - (char*) this) - ALIGNSIZE(sizeof(LOGRECORDHDR)) - 2*ALIGNSIZE(sizeof(LOGPAGEHDR)); }
		};

typedef LogLhashPhysicInsertData LogLhashPhysicDeleteData,
				 LogLhashPhyLogInsertData,
				 LogLhashPhyLogDeleteData;
		
		
struct LogLhashLogicInsertData {
		PID			rootPid;
		TWO			elSize;
		TWO			maxKeyLen;
		TWO			unique;
		TWO			keyLen;
		SMDATATYPE	keyType;
		int 		primary;
		char		data[1];

        int Size()  { return data + ALIGNSIZE(keyLen) + elSize
						- (char*) this; }

        void* Key() { return data; }
		void* El()  { return data + ALIGNSIZE(keyLen); }
		};

typedef LogLhashLogicInsertData LogLhashLogicDeleteData;


struct LogSetIndexOverflowData {
		SHORTPID	oldOvPage;
		SHORTPID	newOvPage;

		int Size()	{ return sizeof(*this); }
		};

struct LogResetIndexOverflowData {
		SHORTPID	oldOvPage;
		int 		keepFlag;

		int Size()	{ return sizeof(*this); }
		};

struct LogLhashOvConvertData {
		FOUR    oldHashVal;
		FOUR    newHashVal;
		BOOL	cvtFlag; 

		int Size()  { return sizeof(*this); }
		};

struct LogDirUpdateData {
		float		oldFromLoad;
		float		fromLoad;
		float		toLoad;
		BOOL		growFlag;

		int Size()	{ return sizeof(*this); }
		};

struct LogSetThresholdData {
		float		oldThreshold;
		float		newThreshold;

		int Size()	{ return sizeof(*this); }
		};

struct LogDirLoadUpdateData {
		float		load1;
		float		load2;

		int Size()	{ return sizeof(*this); }
		};

struct LogDirSetNextEntryData {
		SHORTPID 	newPage;
		FOUR	 	hashVal;

		int Size()	{ return sizeof(*this); }
		};

typedef LogDirSetNextEntryData LogDirUnSetNextEntryData;

struct LogDirRootCtrlData {
		FOUR        M;
		FOUR        P;
		ONE         I;
		FOUR        curPos;
		ONE         height;
		float       load;

		int Size()	{ return sizeof(*this); }
		};

struct LogDirSplitData {
		SHORTPID	newPage1;
		SHORTPID	newPage2;
		FOUR		height;
		FOUR		curPos;
		char		data[1];

		int Size()	{ return data + curPos*sizeof(SHORTPID) 
							 - (char*) this; }
		int Max()	{ return BTREE_PAGESIZE - (data - (char*) this) - 100; }
		};

struct LogLhashLogicIncrElCntData {
		PID         rootPid;
		TWO         maxKeyLen;
		TWO         keyLen;
		SMDATATYPE  keyType;
		char        key[1];

		int Size()  { return key + keyLen - (char*) this; }
        void* Key() { return key; }
};

typedef LogLhashLogicIncrElCntData LogLhashLogicDecrElCntData;

struct LogLhashLogicSetOverflowData {
		PID         rootPid;
		PID         ovPid;
		TWO         maxKeyLen;
		TWO         keyLen;
		TWO         numEl;
		TWO			elSize;
		SMDATATYPE  keyType;
		char        data[1];

		int Size()  { return data + keyLen + numEl*elSize - (char*)this; }
		char*   KeyValue()  { return data; }
		char*   ElList()    { return data + keyLen; }
};

typedef LogLhashLogicSetOverflowData LogLhashLogicResetOverflowData;

#endif /* __LH_LOG_H__ */
#endif /* _LH_LOG_H_ */
