#ifndef _OVPAGE_H_
#define _OVPAGE_H_
/*
 * $RCSfile: OVPAGE.h,v $
 * $Revision: 1.9 $
 * $Date: 1993/03/10 20:22:04 $
 */
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*		     Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*    or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

#ifndef OVPAGE_H
#define OVPAGE_H



//
//  NOTE: both lrc and selfID must be in the same position as those in
//	  BTREEPAGE. This is because we use BTREEPAGE as unit of allocation
//	  in IO level.
//
struct OVCONTROL {
	LRC	    lrc;
	PID	    selfID;
	TWO	    elCnt;
	TWO	    elSize;
	TWO	    maxEl;
	TWO	    dummy;
	SHORTPID    next;
	SHORTPID    prev;
    };

const OV_DATASIZE = BTREE_PAGESIZE - sizeof(OVCONTROL);


/*
#ifdef BT_DEBUG
const OV_MAXOIDCNT = (MAXTUPLESIZE - FIXEDMEM) / sizeof(OID);
#else
const OV_MAXOIDCNT = OV_DATASIZE / sizeof(OID);
#endif
*/

class OVPAGE	{
    
    OVCONTROL   ovCtrl;
    char	c[OV_DATASIZE];	// contents --- an array of elements
    
public:
    
    SHORTPID&   NextPage()	{ return ovCtrl.next; }
    SHORTPID&   PrevPage()	{ return ovCtrl.prev; }
    int	        ElCnt()		{ return ovCtrl.elCnt; }
    int	        ElSize()	{ return ovCtrl.elSize; }
    int	        MaxEl()		{ return ovCtrl.maxEl; }
    
    void	Init(PID& pid, int es);
    
    LRC&	lrc()		{ return ovCtrl.lrc; }
    PID&	SelfID()	{ return ovCtrl.selfID; }
    
    void	Linkup(OVPAGE* rightPage);
    void	Shift(int start, OVPAGE* destPage);
    
    void	Sort();
    
    void*	Get(int idx)	{ ASSERT3(idx < MaxEl()); 
				  return c + idx * ElSize();
				}
    
    void	FillSort(int cnt, void* array);
    void	Insert(int startSlot, int cnt, const void* array);
    void	Remove(int startSlot, int cnt);
    
    int	CheckPage();
};




extern "C" {
    int ov_NewCluster(TID tid, int volume, BUFGROUP* bufGroup,
				int elSize, PID& rootPid, BT_Tuple& tuple);
    int ov_DestroyCluster(TID tid, const PID& rootPid, BUFGROUP* bufGroup);
    int ov_AddElem(TID tid, const PID& rootPid, BUFGROUP* bufGroup, 
				    const void* newElem);
    int ov_RemoveElem(TID tid, const PID& rootPid, BUFGROUP* bufGroup,
				    const void* doomedElem);
    int ov_GetElem(const PID& rootPid, BUFGROUP* bufGroup, int idx, void* ret);
    int OV_AllocPage(TID tid, int volume, BUFGROUP* bufGroup, 
				    int elSize, PID& retPid);
    int OV_FreePage(TID tid, const PID& pid);
    int OV_Search(const PID& pid, BUFGROUP* bufGroup, const void* ep, 
				    PID& retPid, int& found, int& retIdx);
    int OV_Check(const PID& rootPid, BUFGROUP* bufGroup);
    void OV_LogPageInit(PAGEHASH* pHash, TWO elSize);
    void OV_LogModifyNextLink(PID&, PAGEHASH*, LRC&, const PID& rootPid,
				SHORTPID oldNext, SHORTPID newNext,
				LSNOFFSET undoNxtLSN);
    void OV_LogModifyPrevLink(PID&, PAGEHASH*, LRC&, const PID& rootPid, 
				SHORTPID oldPrev, SHORTPID newPrev,
				LSNOFFSET undoNxtLSN);
    void OV_LogInsert(PID&, PAGEHASH*, LRC&, const PID& rootPid, 
				TWO elSize, TWO slotNum, 
				TWO numSlot, void* buff, 
				LSNOFFSET undoNxtLSN);
    void OV_LogDelete(PID&, PAGEHASH*, LRC&, const PID& rootPid,
				TWO elSize, TWO slotNum, 
				TWO numSlot, void* buff,
				LSNOFFSET undoNxtLSN);
};



#endif	// OVPAGE_H
#endif /* _OVPAGE_H_ */
