#ifndef _PARENTSTACK_H_
#define _PARENTSTACK_H_
/*
 *   $RCSfile: ParentStack.h,v $  
 *   $Revision: 1.6 $  
 *   $Date: 1992/11/27 16:45:48 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifndef PARENTSTACK_H
#define PARENTSTACK_H

class ParentStack  {
		int 		cnt;					// # of valid entries in descPtr[]
		BUFGROUP*	bufGroup;				// buffer group associated w. stack
		PageDesc	descPtr[MAXPARENTS];	// pages in stack
	public:
		ParentStack(BUFGROUP* bg)	{ cnt = 0; bufGroup = bg; }
		~ParentStack();
		
		//
		//	Read page 'pid' in 'lockMode' and push it onto the stack
		//
		ReadNPush(const PID& pid, LOCKMODE lm);
		
		//
		//	Unlock/Unfix all entries except top of stack
		//
		void
		ReleaseAllPrevious()	{ 
						for (int i = cnt-2; i>= 0; i--)  {
							if ((GROUPLINK*)descPtr[i])
								descPtr[i].UnfixUnlock();
							}
						}
		
		//
		//	Unlock/Unfix the entry before top of stack
		//
		void
		ReleasePrevious() 		{ 
						if (cnt>1 && (GROUPLINK*) descPtr[cnt-2])
				    	descPtr[cnt-2].UnfixUnlock();
						}
								

		//
		//	Push/Pop a page to/from stack
		//
		PageDesc
		Pop()			{ ASSERT1(cnt > 0); return descPtr[--cnt]; }

		void
		Push(PageDesc pd)	{
						ASSERT1(cnt < MAXPARENTS-1); 
						descPtr[cnt++] = pd; 
						}

		//
		//	Pop a page and unfix/unlock it
		//
		void
		DiscardTop();

		//
		//	Return a reference to the stack top
		//
		PageDesc&
		Top()			{ ASSERT1(cnt > 0); return descPtr[cnt-1]; }

		//
		//	Return current stack size
		//
		NumEntries()	{ return cnt; }
		
		//
		//	Print the stack (for debugging)
		//
		void 
		Print();
		};

#endif // PARENTSTACK_H
#endif /* _PARENTSTACK_H_ */
