#ifndef _POOL_H_
#define _POOL_H_
/*
 *   $RCSfile: Pool.h,v $  
 *   $Revision: 1.5 $  
 *   $Date: 1993/04/02 17:11:24 $      
 */ 

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifndef __cplusplus
	This file MUST be compiled with C++ !
#endif


#include "sysdefs.h"
#include "checking.h"
#include "ess.h"
#include "list.h"
#include "trace.h"
#include "error.h"
#include "ForEach.h"

#define POOL_NOMORE_NULL  	 0x0 	/* quietly return null if we run out */
#define POOL_NOMORE_GETMORE   0x1 	/* get more if we run out  */
#define POOL_NOMORE_ISERROR  0x2 	/* nonfatal error if we run out  */
#define POOL_NOMORE_ISFATAL  0x4 	/* fatal error if we run out  */
							/* none of these--> return null if run out */

template <class CONTENTS>
class Pool {
 
private:
	LIST		freeList;		/* list of available elements */
	LIST		mallocedList;		/* list of malloc-ed areas */
	int			nmallocs;
	int			totalQty;		/* in elements */
	int			lastMallocedQty;		/* # elements last  malloced */
	int			elementSize;	/* in bytes */
	int			currentUsed;
	int			maxUsed;		/* high water mark */
	FLAGS		flags;
	char		name[32];
	int			unique; /* id of resource */
	int			spaceRequirement;	/* in # bytes */

private: 
	void listMake( LIST *list, LIST *mallocList, int elementQty); 

	/* 
	 * The CONTENTS class must have these member functions:
	 * void Init();
	 * void ReInit();
	 * LISTELEMENT *listlocation(int);
	 */
public:
	Pool( char *, int, int, FLAGS);
	~Pool();
	void    		Stats( FILE * );
	CONTENTS    	*Get();
	void    		Put( CONTENTS *);
	void    		Move( CONTENTS *);
#ifdef __GNUC__
	void	ForEach(  int, ... ) ;
#else
	void	ForEach(  int, FOREACHFUNC, ... ) ;
#endif
};

#ifdef  __GNUC__
#include "Pool.c"
#endif  __GNUC__
#endif /* _POOL_H_ */
