#ifndef __TEMPBUFSPACE_H__
#define __TEMPBUFSPACE_H__
/*
 *   $RCSfile: TempBufSpace.h,v $  
 *   $Revision: 1.5 $  
 *   $Date: 1993/04/15 16:42:50 $      
 */ 

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

class TempBufSpace {
public:
			TempBufSpace(int numBytes);
			~TempBufSpace();
	void 	free();
	int	 	length();
	char*	location();

private:
	GROUPLINK	*groupLink;
};


inline
void TempBufSpace::free()
{
	if (groupLink) bf_FreeTempPage(groupLink);
	groupLink = NULL;
}

inline 
TempBufSpace::~TempBufSpace()
{
	free();
}

inline
char* TempBufSpace::location()
{
	return groupLink?groupLink->bufFrame:NULL;
}

inline
int TempBufSpace::length()
{
	return groupLink? (1 << groupLink->pageHash->page2size): 0;
}

#endif __TEMPBUFSPACE_H__
