#ifndef _ADMINMSG_H_
#define _ADMINMSG_H_
/*
 *   $RCSfile: adminmsg.h,v $  
 *   $Revision: 1.13 $  
 *   $Date: 1993/02/13 18:08:33 $      
 */ 
#ifndef __ADMINMSG_H__
#define __ADMINMSG_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#include "sysdefs.h"
#include "msgstats.h"

/* BEGIN visible to user */

/*
 *	Shutdown message flags for SHUTDOWNBODY defined in msgdefs.h
 */
#define SHUT_TAKE_CHECKPOINT	0x1
#define SHUT_DUMP_CORE			0x2
#define SHUT_ABORT_TRANS		0x4
#define SHUT_COMMIT_TRANS		0x8
#define SHUT_CLEAN_VOLUMES		0x10
#define SHUT_ABNORMAL_EXIT		0x20

/*
 *	statistics message flags for STATISTICSBODY defined in msgdefs.h
 */
#define STAT_CLEAR				0x1

/*
 *	Statistics structure returned to clients
 */
typedef struct _ServerStats {
	int		numClients;		/* number of clients connected		*/
	int		numTrans;		/* number of active transactions	*/
	int		numVolumes;		/* number of volumes mounted		*/
	int	    freeLogSpace;   /* approximate number of bytes of free log space */
	int	    chpntFreq;     	/* current checkpoint frequency */
	int	    totalCommits; 	/* counter for number of transactions committed */
	int	    totalAborts;	/* counter for number of transactions aborted */
	int		diskReads;		/* counter for disk read operations	*/
	int		diskWrites; 	/* counter for disk write operations*/

	int		numActiveCoordinator;	/* number of active trans for
								 	   which this server is the coord */
	int		numPreparedParticipant;	/* number of prepared trans for 
									   which the server is a 
									   participant */

	MESSAGESTATS msgStats;  /* server's message stats */

	struct sockaddr_in	 serverAddr;/* inet addr to which server listens */

} SERVERSTATS;

/* END visible to user */

#endif __ADMINMSG_H__
#endif /* _ADMINMSG_H_ */
