/*
 *   $RCSfile: bitvec.h,v $  
 *   $Revision: 1.1 $  
 *   $Date: 1992/11/29 23:51:50 $      
 */ 
#ifndef __BITVEC_H__
#define __BITVEC_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
/*
 *	define operations on bit vectors, specifically for use
 *	with the select bit map
 */
#define BS     	5 
#define BO      31
#define BVL     4
#define MAXBITS (BVL * (1 << BS))


/*
 *	to be used for all bit vectors
 */
typedef struct {

        unsigned long    bv_data[BVL];

} BITVEC;


/*
 *	define the operations on the bit vectors
 */
#define bis(vec, b)      ((vec)->bv_data[(b) >> BS] |= 1 << ((b) & BO))
#define bic(vec, b)      ((vec)->bv_data[(b) >> BS] &= ~(1 << ((b) & BO)))
#define bit(vec, b)      ((vec)->bv_data[(b) >> BS] & (1 << ((b) & BO)))


#define bisv(vec, bv)    {                                              \
            (vec)->bv_data[0] |= (bv)->bv_data[0];                      \
            (vec)->bv_data[1] |= (bv)->bv_data[1];                      \
            (vec)->bv_data[2] |= (bv)->bv_data[2];                      \
            (vec)->bv_data[3] |= (bv)->bv_data[3];                      \
}

#define bandv(vec, bv)   {                                              \
            (vec)->bv_data[0] &= (bv)->bv_data[0];                      \
            (vec)->bv_data[1] &= (bv)->bv_data[1];                      \
            (vec)->bv_data[2] &= (bv)->bv_data[2];                      \
            (vec)->bv_data[3] &= (bv)->bv_data[3];                      \
}

#define bicv(vec, bv)    {                                              \
            (vec)->bv_data[0] &= ~(bv)->bv_data[0];                     \
            (vec)->bv_data[1] &= ~(bv)->bv_data[1];                     \
            (vec)->bv_data[2] &= ~(bv)->bv_data[2];                     \
            (vec)->bv_data[3] &= ~(bv)->bv_data[3];                     \
}

#define bisv2(vec, bv1, bv2)    {                                       \
            (vec)->bv_data[0] = (bv1)->bv_data[0] | (bv2)->bv_data[0];  \
            (vec)->bv_data[1] = (bv1)->bv_data[1] | (bv2)->bv_data[1];  \
            (vec)->bv_data[2] = (bv1)->bv_data[2] | (bv2)->bv_data[2];  \
            (vec)->bv_data[3] = (bv1)->bv_data[3] | (bv2)->bv_data[3];  \
}

#define bitcom(vec, bv1, bv2)    {                                       \
            (vec)->bv_data[0] = ((bv1)->bv_data[0] & (bv2)->bv_data[0]);  \
            (vec)->bv_data[1] = ((bv1)->bv_data[1] & (bv2)->bv_data[1]);  \
            (vec)->bv_data[2] = ((bv1)->bv_data[2] & (bv2)->bv_data[2]);  \
            (vec)->bv_data[3] = ((bv1)->bv_data[3] & (bv2)->bv_data[3]);  \
}

#define btest(vec)             	                                        \
	((vec)->bv_data[0] || (vec)->bv_data[1] || (vec)->bv_data[2] || (vec)->bv_data[3])

#define bitv(vec, bv)    (                                              \
           ((vec)->bv_data[0] & (bv)->bv_data[0]) ||                    \
           ((vec)->bv_data[1] & (bv)->bv_data[1]) ||                    \
           ((vec)->bv_data[2] & (bv)->bv_data[2]) ||                    \
           ((vec)->bv_data[3] & (bv)->bv_data[3])                       \
)

#  define bclr(vec)       { bzero((bitvec*)vec,sizeof(bitvec)); }
#  define bset(vec)       bisv((bitvec*)vec,(bitvec*)&ones)
#endif __BITVEC_H__
