#ifndef _BT_EXTFUNCS_H_
#define _BT_EXTFUNCS_H_
/*
 *   $RCSfile: bt_extfuncs.h,v $  
 *   $Revision: 1.16 $  
 *   $Date: 1993/02/05 05:11:11 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifdef __cplusplus
extern "C" {

extern bt_BulkLoad(TID tid, BUFGROUP* bufGroup, VOLID volid, FID& input, 
                    int cnt, BOOL unique, SMDATATYPE type, 
					int elSize, PID& rootPid);

extern bt_InsertEntry(TID tid, const PID& rootPid, BUFGROUP* bufGroup,
						const void* newKey, int newKeyLen, int elSize, 
						const void* elem, int maxKeyLen, BOOL unique, 
						PFC compFunc, LSNOFFSET undoNxtLSN);

extern bt_RemoveEntry(TID tid, const PID& rootPid, BUFGROUP* bufGroup, 
						const void* doomedKey, int doomedKeyLen, 
						int elSize, const void* elem, int maxKeyLen, 
						BOOL unique, PFC compFunc, LSNOFFSET undoNxtLSN);

extern bt_DestroyBtree(TID tid, const PID& rootPid, BUFGROUP* bufGroup);
extern bt_IsEmpty(TID tid, const PID& rootPid, BUFGROUP* bufGroup, BOOL* ret);
#ifndef SERVER_MAKE
extern bt_CreateBtree(TID tid, int volume, BUFGROUP* bufGroup,
											PID& rootPid, SMDATATYPE type);
extern bt_FetchInit(const PID& rootPid, BUFGROUP* bufGroup, 
						void* bound1, int bound1Len,
						int maxKeyLen, BT_CURSOR* cursor, 
						SMCOND condition, PFC compFunc);

extern bt_FetchNext(BT_CURSOR& cursor, BUFGROUP* bufGroup, void* bound2, 
						int bound2len, SMCOND condition, PFC compFunc, 
						void* valuePtr, TWO* lenPtr, 
						void* ret, BOOL& eof);
#endif

#ifdef SERVER_MAKE
extern bt_LogFormat(VOLREC* volRec, PID* pid, PAGEHASH* pHash);
extern void redoBtreePageFormat(LOGRECORDHDR* record);
#endif

extern void BT_PrintTree(const PID& rootPid, BUFGROUP* bufGroup);
extern bt_CheckTree(const PID& rootPid, BUFGROUP* bufGroup);

}
#endif

#endif /* _BT_EXTFUNCS_H_ */
