#ifndef _CHECKING_H_
#define _CHECKING_H_
/*
 *   $RCSfile: checking.h,v $  
 *   $Revision: 2.16 $  
 *   $Date: 1993/04/09 18:59:03 $      
 */ 
/* BEGIN visible to user */

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	These values are used to define the assert
 *	checking level of the compiled code
 */
#define LEVEL_1		1)
#define LEVEL_2		2)
#define LEVEL_3		3)


#ifdef DEBUG

/*
 *	This value control the level of assert
 *	checking expansion for the current compile
 */
#define ASSERT_LEVEL		(3

#define MAGIC_CHECKING		ENABLED

#define OBJECT_MAGIC		DISABLED

#define LIST_CHECKING		ENABLED

#define PARAM_CHECKING		ENABLED

#define IO_STATISTICS		ENABLED


#else


/*
 *	This value control the level of assert
 *	checking expansion for the current compile
 */
#define ASSERT_LEVEL		(0

#define MAGIC_CHECKING	ENABLED

#define OBJECT_MAGIC		DISABLED

#define LIST_CHECKING		DISABLED

#define PARAM_CHECKING		DISABLED

#define IO_STATISTICS		ENABLED


#endif

/* END visible to user */

#ifndef SERVER_MAKE
/* CLIENT VERSION */
/* BEGIN visible to user */

#define SM_ASSERT(_level, _condition)							\
	if (ASSERT_LEVEL >= _level)	{								\
		if (!(_condition))	{									\
			SM_Error(TYPE_FATAL, esmASSERT, __FILE__, __LINE__);\
		}														\
	}

/* END visible to user */

#else SERVER_MAKE

#ifdef DEBUG

BEGIN_EXTERNC
	extern int SanityCheck();
END_EXTERNC

#ifdef DISKPROC_MAKE
#define SANITY (0)
#else DISKPROC_MAKE
#define SANITY SanityCheck() 
#endif DISKPROC_MAKE

#else

/* SANITY can cause nothing else to get compiled  when !debug */
#define SANITY (1)

#endif DEBUG

/* 
 * NB: be careful with the following definition.
 * The feebleminded compiler (on sparcs) can't
 * figure out that (1 || (0>=3)) is a constant (FALSE)
 * expression and it generates code for if(!(condition)) --
 * causing linkage errors.
 * So we have to use if(1) if(0>=3) ....
 */ 
#define SM_ASSERT(_level, _condition)							\
	if ( SANITY ) {	/* see NB above */							\
		 if (ASSERT_LEVEL >= _level)	{			 			\
			if (!(_condition))	{								\
				SM_Error(TYPE_FATAL, esmASSERT, __FILE__, __LINE__);\
			}													\
		}														\
	}

#endif SERVER_MAKE

#endif /* _CHECKING_H_ */
