/*
 *   $RCSfile: distr.h,v $  
 *   $Revision: 1.3 $  
 *   $Date: 1993/01/13 20:37:44 $      
 */ 
#ifndef __DISTR_H__
#define __DISTR_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
/* BEGIN visible to user */
/*
 * vote returned by ESM Servers
 */
typedef	UONE VOTE;
/* END visible to user */

/*
 * command issued by ESM Coordinator 
 */
typedef	UONE COMMAND;

/*
 *	define a structure to pass between the client and 
 *	the coord containing the SOCKADDR and TID of a
 *	participating server
 */
typedef struct {
	SOCKADDR    connectAddr;
	TID         tid;
} SERVERADDRTID; 


/*
 *	define a record that holds the server info 
 *	consisting of the socket address, tid, vote,
 *	and ack status
 */
typedef struct {

	SOCKADDR	connectAddr;
	TID			tid;
	VOTE		vote;
	BOOL		ack;
	LISTELEMENT serverTidInfoList;

} SERVERTIDINFO; 

/*
 *	maximum number of participating servers in a 
 *	distributed transaction that a coordinator can handle
 */
#define		MAXPARTICIPANTS		20

/* BEGIN visible to user */
/*
 * definitions for the votes from a server to the coordinator
 */
#define		VOTEUNKNOWN	0
#define		YESVOTE		1
#define		NOVOTE		2
#define		READVOTE	3
/* END visible to user */

/*
 * definitions for the commands from the coordinator to a server
 */
#define		C_UNKNOWN	0
#define		C_COMMIT	1
#define		C_ABORT		2

/*
 *	define the macro to check if two internet addresses are the same
 */
#define INET_ADDR_EQ(_addr1, _addr2)				\
													\
	((_addr1.sin_family == _addr2.sin_family)		\
&&	 (_addr1.sin_port	== _addr2.sin_port)			\
&&	 (_addr1.sin_addr.s_addr == _addr2.sin_addr.s_addr))

/*
 *	define the macro to decide if a transaction should be alive
 *	at the end of recovery
 */
#define		TRANS_ALIVE_AFTER_RECOVERY(_transRec)	\
													\
	((_transRec->transState == T_PREPARED) ||		\
	 ((_transRec->transState == T_COMMIT) &&		\
	  (_transRec->numServers > 0))) 

/*
 *	define the macro to decide if a transaction was really alive
 *	at the time of a checkpoint 
 */
#define		TRANS_NOT_ALIVE_AT_CHECKPOINT(_checkTrans)	\
														\
	( (_checkTrans->state != T_ACTIVE) &&				\
	  (_checkTrans->state != T_PREPARED) &&				\
	  (!((_checkTrans->state == T_COMMIT) &&			\
	     (_checkTrans->numServers > 0))) )

/*
 *	define the macro to decide if a transaction is prepared 
 *	and this server is a participant	
 */
#define		TRANS_PREPARED_PARTICIPANT(_transRec)	\
													\
	 ((_transRec->transState == T_PREPARED) &&		\
	  (_transRec->numServers == 0))

/*
 *	timeout values for timers
 */
#define		T_COORDTIMEOUT		2
#define		T_SERVERTIMEOUT		2
#define		T_SHUTDOWNTIMEOUT	10

#endif __DISTR_H__
