#ifndef _ERROR_H_
#define _ERROR_H_
/*
 *   $RCSfile: error.h,v $  
 *   $Revision: 2.41 $  
 *   $Date: 1993/04/08 16:24:37 $      
 */ 
#ifndef __ERROR_H__
#define __ERROR_H__
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	Functions for using error codes and messages
 */
BEGIN_EXTERNC

extern void 	initErrorCodes();
extern char*	errorCodeString(int);
extern char*	errorBaseString(int);
extern char*	errorIdString(int);
extern FILE*	sm_ErrorStream;
extern void		SM_Error(int, int, char *, int);
END_EXTERNC

typedef struct {

	int		code;
	char	*id;
	char	*message;

} ERRORINFO;


typedef struct {

	int	 	errorBase;
	int		maxErrorNum;	/* number of error codes in base */
	char	*baseId;
	char	*baseMessage;
} ERRORBASEINFO;


/*
 *	Arrays of error code/messages
 */
extern ERRORBASEINFO ErrorBaseInfo[];
extern ERRORINFO *ErrorBase[];
extern BOOL		 ErrorBaseInit;
extern ERRORINFO UNIX_ErrorInfo[];
extern ERRORINFO GENERAL_ErrorInfo[];
extern ERRORINFO SM_ErrorInfo[];
extern ERRORINFO BF_ErrorInfo[];
extern ERRORINFO LG_ErrorInfo[];
extern ERRORINFO EH_ErrorInfo[];
extern ERRORINFO FI_ErrorInfo[];
extern ERRORINFO IO_ErrorInfo[];
extern ERRORINFO MSG_ErrorInfo[];
extern ERRORINFO THREAD_ErrorInfo[];
extern ERRORINFO BM_ErrorInfo[];
extern ERRORINFO TRANS_ErrorInfo[];
extern ERRORINFO LM_ErrorInfo[];
extern ERRORINFO LOG_ErrorInfo[];
extern ERRORINFO RESOURCE_ErrorInfo[];
extern ERRORINFO RECOVER_ErrorInfo[];
extern ERRORINFO IM_ErrorInfo[];
extern ERRORINFO OPT_ErrorInfo[];
extern ERRORINFO DISTR_ErrorInfo[];


/* BEGIN visible to user */

/*
 *	Define types of storage manager errors
 */
#define TYPE_USER		0
#define TYPE_LOG		1
#define TYPE_WARNING	2
#define TYPE_SYS		3
#define TYPE_FATAL		4 /* kill server and dump core */
#define TYPE_CRASH		5
	/* 
	 *	TYPE_CRASH is used for errors which the storage manager 
	 * 	should be able to "handle" but are not dealt with at
	 * 	this time
	 */
#define TYPE_STOP		6 
#define TYPE_QUIET		7 /* like TYPE_STOP but no message given */
	

/*
 *	Macro to encode error code as a base number in the upper 16 bits
 *	and an error number in the lower 16 bits
 */
#define	SM_ERR_ENCODE(_base, _number)					\
	( ((_base) << 16) + (_number) )


/*
 *	Macro to decode the error number
 */
#define	SM_ERR_DECODE(_code)					\
	(  (_code) & (0x0000FFFF ) )

/*
 *	Macro to decode the base number for the error
 */
#define	SM_ERR_BASE_DECODE(_code)					\
	(  (_code) >> 16 )


#define UNIX_ERROR_BASE			0
#define GENERAL_ERROR_BASE		1
#define SM_ERROR_BASE			2
#define BF_ERROR_BASE			3
#define LG_ERROR_BASE			4
#define EH_ERROR_BASE			5
#define FI_ERROR_BASE			6
#define IO_ERROR_BASE			7
#define MSG_ERROR_BASE			8
#define THREAD_ERROR_BASE		9
#define BM_ERROR_BASE			10
#define TRANS_ERROR_BASE		11
#define LOCK_ERROR_BASE			12
#define LOG_ERROR_BASE			13
#define RESOURCE_ERROR_BASE		14
#define RECOVER_ERROR_BASE		15
#define IM_ERROR_BASE			16
#define OPT_ERROR_BASE			17
#define DISTR_ERROR_BASE        18
#define MAX_ERROR_BASE			19 	/* always last */

/*
 *	The unix errors are defined in /usr/include/errno.h
 */
#define MAX_UNIX_ERROR			0x0fffffff /* unknown */

/*
 *	define the general errors
 */
#define esmINTERNAL				SM_ERR_ENCODE(GENERAL_ERROR_BASE, 1)
#define esmASSERT				SM_ERR_ENCODE(GENERAL_ERROR_BASE, 2)
#define esmMALLOCFAILED			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 3)
#define esmSERVERDIED			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 4)
#define esmNOTIMPLEMENTED		SM_ERR_ENCODE(GENERAL_ERROR_BASE, 5)
#define esmUNIXSIGNAL			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 6)
#define esmPOOLEMPTY			SM_ERR_ENCODE(GENERAL_ERROR_BASE, 7)
#define MAX_GENERAL_ERROR		8 /* adjust as errors added/removed */

/*
 *	define the sm layer errors
 */
#define esmBADOID				SM_ERR_ENCODE(SM_ERROR_BASE, 1)
#define esmBADSTART				SM_ERR_ENCODE(SM_ERROR_BASE, 2)
#define esmNOFREEUSERDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 3)
#define esmBADUSERDESC			SM_ERR_ENCODE(SM_ERROR_BASE, 4)
#define esmBADPARAMS			SM_ERR_ENCODE(SM_ERROR_BASE, 5)
#define esmBADGROUP				SM_ERR_ENCODE(SM_ERROR_BASE, 6)
#define esmBADLENGTH			SM_ERR_ENCODE(SM_ERROR_BASE, 7)
#define esmROOTNAMETOOLONG		SM_ERR_ENCODE(SM_ERROR_BASE, 8)
#define esmNOFREESCANDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 9)
#define esmENDOFOBJECT			SM_ERR_ENCODE(SM_ERROR_BASE, 10)
#define esmBADSLOTTEDMAGIC		SM_ERR_ENCODE(SM_ERROR_BASE, 11)
#define esmBADOBJECTMAGIC		SM_ERR_ENCODE(SM_ERROR_BASE, 12)
#define esmBADOBJECTFLAGS		SM_ERR_ENCODE(SM_ERROR_BASE, 13)
#define esmNOFREELOADDESC		SM_ERR_ENCODE(SM_ERROR_BASE, 14)
#define esmHISTORYGRAPHOID		SM_ERR_ENCODE(SM_ERROR_BASE, 15)
#define esmNOTVERSIONED			SM_ERR_ENCODE(SM_ERROR_BASE, 16) /* obj not a version */
#define esmNOTFROZEN			SM_ERR_ENCODE(SM_ERROR_BASE, 17) /* obj not frozen */
#define esmFROZEN				SM_ERR_ENCODE(SM_ERROR_BASE, 18) /* obj is frozen */
#define esmVHGTOOLARGE			SM_ERR_ENCODE(SM_ERROR_BASE, 19) 
#define MAX_SM_ERROR			20 /* adjust as errors added/removed */


/*
 *	define the bf related error
 */
#define esmCANTSWAP				SM_ERR_ENCODE(BF_ERROR_BASE, 1)
#define esmFIXEDPAGES			SM_ERR_ENCODE(BF_ERROR_BASE, 2)
#define esmNOFREEPAGEHASH		SM_ERR_ENCODE(BF_ERROR_BASE, 3)
#define esmNOUNRESERVED			SM_ERR_ENCODE(BF_ERROR_BASE, 4)
#define esmNOFREEGROUPS			SM_ERR_ENCODE(BF_ERROR_BASE, 5)
#define esmBADREPLACEPOLICY		SM_ERR_ENCODE(BF_ERROR_BASE, 6)
#define esmPAGEGONE				SM_ERR_ENCODE(BF_ERROR_BASE, 7)
#define esmNOBUFSPACE			SM_ERR_ENCODE(BF_ERROR_BASE, 8)
#define esmREQUESTTOOBIG		SM_ERR_ENCODE(BF_ERROR_BASE, 9)
#define esmGROUPGONE			SM_ERR_ENCODE(BF_ERROR_BASE, 10)
#define esmNOSHMSPACE			SM_ERR_ENCODE(BF_ERROR_BASE, 11)
#define MAX_BF_ERROR			12 /* adjust as errors added/removed */


/*
 *	define the large object related errors
 */
#define esmBADRANGE				SM_ERR_ENCODE(LG_ERROR_BASE, 1)
#define esmNOFREELGNODELIST		SM_ERR_ENCODE(LG_ERROR_BASE, 2)
#define MAX_LG_ERROR			3 /* adjust as errors added/removed */

/*
 *	define the error handler related errors
 */
#define MAX_EH_ERROR            0 /* adjust as errors added/removed */

/*
 *	define the file layer errors
 */
#define esmEMPTYFILE			SM_ERR_ENCODE(FI_ERROR_BASE, 1)
#define esmBADNEARTYPE			SM_ERR_ENCODE(FI_ERROR_BASE, 2)
#define esmBADFILEPAGEMAGIC		SM_ERR_ENCODE(FI_ERROR_BASE, 3)
#define esmAFTERLASTPID			SM_ERR_ENCODE(FI_ERROR_BASE, 4)
#define esmBEFOREFIRSTPID		SM_ERR_ENCODE(FI_ERROR_BASE, 5)
#define esmFILESTACKOVERFLOW	SM_ERR_ENCODE(FI_ERROR_BASE, 6)
#define esmFILEPAGENOTFOUND		SM_ERR_ENCODE(FI_ERROR_BASE, 7)
#define esmNOFREEFILESTACK		SM_ERR_ENCODE(FI_ERROR_BASE, 8)
#define esmPAGEEXISTS			SM_ERR_ENCODE(FI_ERROR_BASE, 9)
#define esmPAGEMARKED			SM_ERR_ENCODE(FI_ERROR_BASE, 10)
#define esmBADFID				SM_ERR_ENCODE(FI_ERROR_BASE, 11)
#define esmNOFREEFIDHASH		SM_ERR_ENCODE(FI_ERROR_BASE, 12)
#define esmFILENOTLOGICAL		SM_ERR_ENCODE(FI_ERROR_BASE, 13)
#define esmBADPAGESIZE			SM_ERR_ENCODE(FI_ERROR_BASE, 14)
#define esmBADFILEHEADERMAGIC	SM_ERR_ENCODE(FI_ERROR_BASE, 15)
#define esmNOFREEOPENFILE		SM_ERR_ENCODE(FI_ERROR_BASE, 16)
#define MAX_FILE_ERROR			17 /* adjust as errors added/removed */


/*
 *	define the io related errors
 */
#define esmBADVOLHEADER			SM_ERR_ENCODE(IO_ERROR_BASE, 1)
#define esmDUPVOLID				SM_ERR_ENCODE(IO_ERROR_BASE, 2)
#define esmDISKPROCDIED			SM_ERR_ENCODE(IO_ERROR_BASE, 3)
#define esmBADVOLID				SM_ERR_ENCODE(IO_ERROR_BASE, 4)
#define esmDUPVOLNAME			SM_ERR_ENCODE(IO_ERROR_BASE, 5)
#define esmFRAGMENTED			SM_ERR_ENCODE(IO_ERROR_BASE, 6)
#define esmDISKFULL				SM_ERR_ENCODE(IO_ERROR_BASE, 7)
#define esmDISKMOUNTED			SM_ERR_ENCODE(IO_ERROR_BASE, 8)
#define esmBADROOTNAME			SM_ERR_ENCODE(IO_ERROR_BASE, 9)
#define esmROOTTABLEFULL		SM_ERR_ENCODE(IO_ERROR_BASE, 10)
#define esmNOVOLINFO			SM_ERR_ENCODE(IO_ERROR_BASE, 11)
#define esmNOFREECONTEXT		SM_ERR_ENCODE(IO_ERROR_BASE, 12)
#define esmBADPID				SM_ERR_ENCODE(IO_ERROR_BASE, 13)
#define esmSERVPROCDIED			SM_ERR_ENCODE(IO_ERROR_BASE, 14)
#define esmNOSUCHVOLUME			SM_ERR_ENCODE(IO_ERROR_BASE, 15)
#define esmMOUNTTABLEFULL		SM_ERR_ENCODE(IO_ERROR_BASE, 16)

#define MAX_IO_ERROR			17 /* adjust as errors added/removed */


/*
 *	define the message related errors
 */
#define esmPROTOCOLVERSION		SM_ERR_ENCODE(MSG_ERROR_BASE, 1)
#define esmBADMESSAGENUMBER		SM_ERR_ENCODE(MSG_ERROR_BASE, 2)
#define esmBADMESSAGEMAGIC		SM_ERR_ENCODE(MSG_ERROR_BASE, 3)
#define esmALREADYCONNECTED		SM_ERR_ENCODE(MSG_ERROR_BASE, 4)
#define esmNOTCONNECTED			SM_ERR_ENCODE(MSG_ERROR_BASE, 5)
#define esmNOFREETIMERS			SM_ERR_ENCODE(MSG_ERROR_BASE, 6)
#define esmUNKNOWNHOSTNAME      SM_ERR_ENCODE(MSG_ERROR_BASE, 7)
#define esmCONFIGMISMATCH		SM_ERR_ENCODE(MSG_ERROR_BASE, 8)
#define esmBADFAMILY			SM_ERR_ENCODE(MSG_ERROR_BASE, 9)
#define MAX_MSG_ERROR          10 /* adjust as errors added/removed */


/*
 *	define the thread related errors
 */
#define esmNOFREETHREAD			SM_ERR_ENCODE(THREAD_ERROR_BASE, 1)
#define MAX_THREAD_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the bitmap related error
 */
#define esmNOFREEPAGECONTEXT	SM_ERR_ENCODE(BM_ERROR_BASE, 1)
#define esmTOOMANYBITS			SM_ERR_ENCODE(BM_ERROR_BASE, 2)
#define MAX_BM_ERROR			3 /* adjust as errors added/removed */


/*
 *	define the transaction related errors
 */
#define esmNOFREETRANSREC		SM_ERR_ENCODE(TRANS_ERROR_BASE, 1)
#define esmTRANSDISABLED		SM_ERR_ENCODE(TRANS_ERROR_BASE, 2)
#define esmBADTRANSID			SM_ERR_ENCODE(TRANS_ERROR_BASE, 3)
#define esmNOTTRANSMASTER		SM_ERR_ENCODE(TRANS_ERROR_BASE, 4)
#define esmTRANSABORTED			SM_ERR_ENCODE(TRANS_ERROR_BASE, 5)
#define esmTRANSCOMMITTED		SM_ERR_ENCODE(TRANS_ERROR_BASE, 6)
#define esmNOFREETRANSVOLREC	SM_ERR_ENCODE(TRANS_ERROR_BASE, 7)
#define esmTRANSINPROGRESS		SM_ERR_ENCODE(TRANS_ERROR_BASE, 8)
#define esmNOACTIVETRANS		SM_ERR_ENCODE(TRANS_ERROR_BASE, 9)
#define esmCLIENTREQUEST		SM_ERR_ENCODE(TRANS_ERROR_BASE, 10)
#define MAX_TRANS_ERROR			11 /* adjust as errors added/removed */


/*
 *	define the locking related errors
 */
#define esmBADLOCKTABLESIZE		SM_ERR_ENCODE(LOCK_ERROR_BASE, 1)
#define esmBADLOCKMODE			SM_ERR_ENCODE(LOCK_ERROR_BASE, 2)
#define esmNOFREELOCKHEADER		SM_ERR_ENCODE(LOCK_ERROR_BASE, 3)
#define esmNOFREELOCKENTRY		SM_ERR_ENCODE(LOCK_ERROR_BASE, 4)
#define esmNOFREELOCKCLASSREC	SM_ERR_ENCODE(LOCK_ERROR_BASE, 5)
#define esmNOFREELOCKCLASS		SM_ERR_ENCODE(LOCK_ERROR_BASE, 6)
#define esmBADLOCKCLASS			SM_ERR_ENCODE(LOCK_ERROR_BASE, 7)
#define esmLOCKBUSY				SM_ERR_ENCODE(LOCK_ERROR_BASE, 8)
#define esmLOCKCAUSEDDEADLOCK	SM_ERR_ENCODE(LOCK_ERROR_BASE, 9)
#define esmNOSUCHLOCK			SM_ERR_ENCODE(LOCK_ERROR_BASE, 10)
#define esmWAITEREXISTS			SM_ERR_ENCODE(LOCK_ERROR_BASE, 11)
#define esmPHANTOMDEADLOCK		SM_ERR_ENCODE(LOCK_ERROR_BASE, 12)
#define esmCAUSEDPHANTOMDEADLOCK SM_ERR_ENCODE(LOCK_ERROR_BASE, 13)
#define esmLOCKPREEMPTED 		SM_ERR_ENCODE(LOCK_ERROR_BASE, 14)
#define MAX_LOCK_ERROR			15 /* adjust as errors added/removed */


/*
 *	define the logging related errors
 */
#define esmLOGDISABLED			SM_ERR_ENCODE(LOG_ERROR_BASE, 1)
#define esmLOGWRAPPED			SM_ERR_ENCODE(LOG_ERROR_BASE, 2)
#define esmNOFREELOGSPACE		SM_ERR_ENCODE(LOG_ERROR_BASE, 3)
#define esmLOGRECORDTOOBIG		SM_ERR_ENCODE(LOG_ERROR_BASE, 4)
#define esmBADLOGPAGEHEADER		SM_ERR_ENCODE(LOG_ERROR_BASE, 5)
#define esmBADLOGRECORDHEADER	SM_ERR_ENCODE(LOG_ERROR_BASE, 6)
#define esmBADLOGVOLUME			SM_ERR_ENCODE(LOG_ERROR_BASE, 7)
#define esmMOUNTLSNTOOHIGH		SM_ERR_ENCODE(LOG_ERROR_BASE, 8)
#define esmLOGTOOSMALL			SM_ERR_ENCODE(LOG_ERROR_BASE, 9)
#define esmLOGGINGOFF			SM_ERR_ENCODE(LOG_ERROR_BASE, 10)
#define MAX_LOG_ERROR			11 /* adjust as errors added/removed */


/*
 *	define the resource related errors
 */
#define esmBADRESOURCE			SM_ERR_ENCODE(RESOURCE_ERROR_BASE, 1)
#define MAX_RESOURCE_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the recovery related errors
 */
#define	esmCANNOTRECOVER		SM_ERR_ENCODE(RECOVER_ERROR_BASE, 1)
#define MAX_RECOVER_ERROR		2 /* adjust as errors added/removed */


/*
 *	define the Index Manager related errors
 */
#define esmKEYNOTFOUND			SM_ERR_ENCODE(IM_ERROR_BASE, 1)
#define esmKEYALREADYEXISTS		SM_ERR_ENCODE(IM_ERROR_BASE, 2)
#define esmDUPLICATEKEYPID		SM_ERR_ENCODE(IM_ERROR_BASE, 3)
#define esmKEYTOOLONG			SM_ERR_ENCODE(IM_ERROR_BASE, 4)
#define esmMAXKEYLENEXCEEDED	SM_ERR_ENCODE(IM_ERROR_BASE, 5)
#define esmOIDNOTFOUND			SM_ERR_ENCODE(IM_ERROR_BASE, 6)
#define esmOIDEXISTS			SM_ERR_ENCODE(IM_ERROR_BASE, 7)
#define esmINVALIDDIRECTION		SM_ERR_ENCODE(IM_ERROR_BASE, 8)
#define esmSCANEXHAUST			SM_ERR_ENCODE(IM_ERROR_BASE, 9)
#define esmINVALIDCURSOR		SM_ERR_ENCODE(IM_ERROR_BASE, 10)
#define esmINVALIDCOND			SM_ERR_ENCODE(IM_ERROR_BASE, 11)
#define esmCONFLICTCOND			SM_ERR_ENCODE(IM_ERROR_BASE, 12)
#define esmBULKLOADING          SM_ERR_ENCODE(IM_ERROR_BASE, 13)
#define esmINDEXNOTEMPTY        SM_ERR_ENCODE(IM_ERROR_BASE, 14)
#define esmNEEDTEMPVOL			SM_ERR_ENCODE(IM_ERROR_BASE, 15)
#define esmWRONGNDXTYPE			SM_ERR_ENCODE(IM_ERROR_BASE, 16)
#define esmWRONGHASHLOAD		SM_ERR_ENCODE(IM_ERROR_BASE, 17)
#define MAX_IM_ERROR			18 /* adjust as errors added/removed */

/*
 *	define the option processing related errors
 */
#define esmBADOPTION			SM_ERR_ENCODE(OPT_ERROR_BASE, 1)
#define esmOPTIONSYNTAX			SM_ERR_ENCODE(OPT_ERROR_BASE, 2)
#define esmOPTIONNOTUNIQUE		SM_ERR_ENCODE(OPT_ERROR_BASE, 3)
#define esmOPTIONNOTSET			SM_ERR_ENCODE(OPT_ERROR_BASE, 4)
#define esmBADOPTIONCLASS		SM_ERR_ENCODE(OPT_ERROR_BASE, 5)
#define esmBADOPTIONVALUE		SM_ERR_ENCODE(OPT_ERROR_BASE, 6)
#define esmBUFPAGESNOTSET		SM_ERR_ENCODE(OPT_ERROR_BASE, 7)
#define MAX_OPT_ERROR			8 /* adjust as errors added/removed */

/*
 *	define the distributed transaction related errors
 */
#define esmTRANSNOTPREPARED		SM_ERR_ENCODE(DISTR_ERROR_BASE, 1)
#define esmBADCOMMAND			SM_ERR_ENCODE(DISTR_ERROR_BASE, 2)
#define esmNOFREEGTIDREC		SM_ERR_ENCODE(DISTR_ERROR_BASE, 3)
#define esmTOOMANYSERVERS		SM_ERR_ENCODE(DISTR_ERROR_BASE, 4)
#define esmNOFREESERVERTIDINFO	SM_ERR_ENCODE(DISTR_ERROR_BASE, 5)
#define esmBADHANDLE			SM_ERR_ENCODE(DISTR_ERROR_BASE, 6)
#define esmWOULDBLOCK			SM_ERR_ENCODE(DISTR_ERROR_BASE, 7)
#define esmBADVOTE				SM_ERR_ENCODE(DISTR_ERROR_BASE, 8)
#define esmBADSTATE				SM_ERR_ENCODE(DISTR_ERROR_BASE, 9)
#define esmCOORDUNKNOWN			SM_ERR_ENCODE(DISTR_ERROR_BASE, 10)
#define esmTRANSPREPARED		SM_ERR_ENCODE(DISTR_ERROR_BASE, 11)
#define esmTRANSIN2PC			SM_ERR_ENCODE(DISTR_ERROR_BASE, 12)
#define esmTRANSNOTIN2PC		SM_ERR_ENCODE(DISTR_ERROR_BASE, 13)
#define MAX_DISTR_ERROR			14 /* adjust as errors added/removed */

/*
 *	Define error for handling macros
 */
#define SM_ERROR(type, code)					\
	SM_Error((type), (code), __FILE__, __LINE__)
/* END visible to user */

#ifndef SERVER_MAKE
/* BEGIN visible to user */
#define SM_TRANSABORTED(type, reason)	\
	sm_reason = reason;\
	SM_Error((type), esmTRANSABORTED, __FILE__, __LINE__)
/* END visible to user */
#endif SERVER_MAKE


#endif __ERROR_H__
#endif /* _ERROR_H_ */
