#ifndef _LH_EXTFUNCS_H_
#define _LH_EXTFUNCS_H_
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#ifdef __cplusplus
extern "C" {


extern int lh_InsertEntry(TID tid, PID& const dirPid, BUFGROUP* bufGroup,
						void* newKey, int newKeyLen, int elSize, 
						void* const elem, int maxKeyLen, int unique,
						PFC compFunc, BOOL loadCalc);

extern int lh_RemoveEntry(TID tid, PID& const dirPid, BUFGROUP* bufGroup, 
						void* doomedKey, int newKeyLen, int elSize,
						void* const elem, int maxKeyLen, int unique,
						PFC compFunc, BOOL loadCalc);

extern int lh_DestroyIndex(TID tid, PID& const dirPid, BUFGROUP* bufGroup);
extern lh_IsEmpty(TID tid, PID& const rootPid, BUFGROUP* bufGroup, BOOL* ret);

#ifndef SERVER_MAKE
	extern int lh_CreateIndex(TID tid, int volume, BUFGROUP* bufGroup,
											PID& dirPid, SMDATATYPE type);
	extern int lh_FetchInit(PID& const dirPid, BUFGROUP* bufGroup, 
						void* bound1, int bound1Len,
						int maxKeyLen, BT_CURSOR* cursor, 
						SMCOND condition, PFC compFunc);

	extern int lh_FetchNext(BT_CURSOR& cursor, BUFGROUP* bufGroup, 
						void* bound2, int bound2len, SMCOND condition, 
						PFC compFunc, void* valuePtr, TWO* lenPtr, void* ret);

	extern int lh_SetLoadThreshold(PID& const rootPid, BUFGROUP* bufGroup,
									float load);
	extern int lh_BulkLoad(TID tid, int volume, INDEXDESC*  ndxDesc,
						FID& fid, BUFGROUP* bufGroup, 
						int cnt, int level, int splitPtr);
#endif

extern void LH_PrintIndex(PID& const dirPid, BUFGROUP* bufGroup);
extern int lh_CheckIndex(PID& const dirPid, BUFGROUP* bufGroup);

}
#endif

#endif /* _LH_EXTFUNCS_H_ */
