#ifndef _LIST_H_
#define _LIST_H_
/*
 *   $RCSfile: list.h,v $  
 *   $Revision: 2.8 $  
 *   $Date: 1992/11/27 16:46:07 $      
 */ 
#ifndef __LIST_H__
#define __LIST_H__


/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
#include "checking.h"

/* BEGIN visible to E interpreter */

/*
 *	This defines the general structure of linked lists
 *	that will be used throughout the storage manager
 */


/*
 *	this defines the head of a list
 */
struct _List	{

	struct _List	*succ;
	struct _List	*pred;
	void			*item;
	MAGIC			magic;

};
typedef  struct _List LIST;


/*
 *	this defines a member of the list
 */
typedef LIST	LISTELEMENT;


/*
 *	Define the magic number for lists
 */
#define LISTMAGIC		0xae1fc83b


/*
 *	These macros define what can be performed on lists
 */
#define LIST_EMPTY(_head)			(((_head)->succ) == ((_head)))

#define LIST_NOT_EMPTY(_head)		(((_head)->succ) != ((_head)))

#define LIST_MEMBER(_element)		((_element)->succ != 0)

#define NOT_LIST_MEMBER(_element)	((_element)->succ == 0)

#define FIRST_LIST_ELEMENT_ITSELF(_head)	((_head)->succ)
#define FIRST_LIST_ELEMENT(_head)	((_head)->succ->item)

#define LAST_LIST_ELEMENT_ITSELF(_head)	((_head)->pred)
#define LAST_LIST_ELEMENT(_head)	((_head)->pred->item)

#define NEXT_LIST_ELEMENT_ITSELF(_element)	((_element)->succ)
#define NEXT_LIST_ELEMENT(_element)	((_element)->succ->item)



#if LIST_CHECKING IS_ENABLED

#define CHECK_LIST_MAGIC(_element)							\
															\
	if ((_element)->magic != LISTMAGIC)	{					\
		TRPRINT(TR_LIST, TR_LEVEL_1,("bad list magic"));	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);					\
	}

#define INIT_LIST_MAGIC(_element)							\
															\
	(_element)->magic = LISTMAGIC;


#else

#define CHECK_LIST_MAGIC(_element)

#define INIT_LIST_MAGIC(_element)

#endif




/*
 *	define macros for list operations
 */

#define INITIALIZELIST(_head)								                \
{																			\
	(_head)->succ = (_head)->pred = _head;									\
	(_head)->item = NULL;													\
	INIT_LIST_MAGIC(_head);													\
}


#define INITIALIZELISTELEMENT(_element, _item)								\
{																			\
	((LIST *)_element)->item = (void *) _item;								\
	((LIST *)_element)->succ = NULL;										\
	INIT_LIST_MAGIC(((LIST *)_element));									\
}





#define LISTDEQ(_head, _element)										  	\
{																			\
	register LIST		*offElement;										\
																			\
																			\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("head:%x", _head));						\
																			\
	CHECK_LIST_MAGIC(_head);												\
																			\
	/*																		\
	 *	Check to see if there is anything on the list						\
	 */																		\
	if (LIST_EMPTY(_head))	{												\
		/*																	\
		 *	there were no elements											\
		 */																	\
		_element = NULL;													\
																			\
	} else {																\
		/*																	\
		 *	Take the first element off the list								\
		 */																	\
		(offElement)	 	= (_head)->succ;								\
		(_head)->succ		= (offElement)->succ;							\
		(_head)->succ->pred = _head;										\
		(offElement)->succ	= NULL;											\
																			\
		/*																	\
		 *	make the final assignment										\
		 */																	\
		_element = offElement;												\
		CHECK_LIST_MAGIC(_element);											\
	}																		\
	TRPRINT(TR_LIST, TR_LEVEL_2, ("element:%x", _element));                 \
}

#define LISTDEQITEM(_head, _element, _type)									\
{																			\
	register LIST		*_listelement;										\
																			\
	LISTDEQ(_head,_listelement);											\
																			\
	if( _listelement != NULL) 												\
		_element = (_type *) _listelement->item;							\
	else																	\
		_element = (_type *) NULL;											\
}


#define LISTMOVE(_source, _dest)											\
{																			\
																			\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("source:%x dest:%x", _source, _dest));	\
																			\
	CHECK_LIST_MAGIC(_source);												\
	CHECK_LIST_MAGIC(_dest);												\
																			\
	/*																		\
	 *	Check to see if there is anything on the list						\
	 */																		\
	if (LIST_NOT_EMPTY(_source))	{										\
		/*																	\
		 *	Take the first element off the list								\
		 */																	\
		(_source)->pred->succ = (_dest);									\
		(_source)->succ->pred = (_dest)->pred;								\
		(_dest)->pred->succ   = (_source)->succ;							\
		(_dest)->pred		  = (_source)->pred;							\
		INITIALIZELIST((_source));											\
	}																		\
}



/*
 *	macro to put an element on a list
 */
#define LISTENQ(_head, _element)										\
{																		\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("head:%x element:%x", _head, _element));\
																		\
	CHECK_LIST_MAGIC(_head);											\
	CHECK_LIST_MAGIC(_element);											\
																		\
	/*																	\
	 *	Check to see if the item is already on a list					\
	 */																	\
	if ((_element)->succ != NULL)	{									\
		TRPRINT(TR_LIST, TR_LEVEL_1,("element already on list"));       \
		SM_ERROR(TYPE_FATAL, esmINTERNAL);								\
	} else {															\
		/*																\
		 *	Put the item last on the list								\
		 */																\
		(_element)->succ 	   = (_head);								\
		(_element)->pred 	   = (_head)->pred;							\
		(_element)->pred->succ = (_element);							\
		(_head)->pred		   = (_element);							\
	}																	\
}

/*
 *	macro to put an element on a list
 */
#define LISTPUSH(_head, _element)										\
{																		\
																		\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("head:%x element:%x", _head, _element));\
																		\
	CHECK_LIST_MAGIC(_head);											\
	CHECK_LIST_MAGIC(_element);											\
																		\
	/*																	\
	 *	Check to see if the item is already on a list					\
	 */																	\
	if ((_element)->succ != NULL)	{									\
		TRPRINT(TR_LIST, TR_LEVEL_1,("element already on list"));       \
		SM_ERROR(TYPE_FATAL, esmINTERNAL);								\
	} else {															\
		/*																\
		 *	Put the item first on the list								\
		 */																\
		(_element)->pred 	   = (_head);								\
		(_element)->succ 	   = (_head)->succ;							\
		(_element)->succ->pred = (_element);							\
		(_head)->succ		   = (_element);							\
	}																	\
}



/*
 *	define macro for list removal with all checks enabled
 */
#define LISTREMOVE(_element)												\
{																			\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("element:%x", _element));					\
																			\
	CHECK_LIST_MAGIC(_element);												\
																			\
	/*																		\
	 *	check to see if item is on the list									\
	 */																		\
	if ((_element)->succ == NULL)	{										\
		/*																	\
		 *	This should not happen											\
		 */																	\
		TRPRINT(TR_LIST, TR_LEVEL_1,("element not on list"));        		\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);									\
																			\
	} else {																\
		/*																	\
		 *	Remove it from the list											\
		 */																	\
		(_element)->succ->pred = (_element)->pred;							\
		(_element)->pred->succ = (_element)->succ;							\
		(_element)->succ = NULL;											\
	}																		\
}


#define LISTMOVEPUSH(_head, _element)										\
{																			\
	TRPRINT(TR_LIST, TR_LEVEL_1, ("head:%x element:%x", (_head), (_element)));\
	CHECK_LIST_MAGIC((_head));												\
	CHECK_LIST_MAGIC((_element));											\
	/*																		\
	 *	Consistency check for (_element)									\
	 */																		\
	if ((_element)->succ == NULL)	{										\
		TRPRINT(TR_LIST, TR_LEVEL_1,("element not on list"));        		\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);   								\
	} else {																\
		/*																	\
		 *	Remove the (_element) from the list								\
		 */																	\
		(_element)->succ->pred = (_element)->pred;							\
		(_element)->pred->succ = (_element)->succ;							\
		/*																	\
		 *	Put the item first on the list									\
		 */																	\
		(_element)->pred 		= (_head);									\
		(_element)->succ 		= (_head)->succ;							\
		(_element)->succ->pred = (_element);								\
		(_head)->succ			= (_element);								\
	}																		\
}


/*
 *	define the prototypes for list functions
 */
#ifdef __cplusplus


extern "C" void		initializeList (LIST *);
extern "C" void		initializeListElement (LISTELEMENT *, void *);
extern "C" void		*listDeq (LIST *);
extern "C" void		listEnq (LIST *, LISTELEMENT *);
extern "C" void		listPush (LIST *, LISTELEMENT *);
extern "C" void		listRemove (LISTELEMENT *);
extern "C" void		listAppend (LIST *, LIST *);
extern "C" void		listInsertAfter (LISTELEMENT *, LISTELEMENT *);
extern "C" void		listInsertBefore (LISTELEMENT *, LISTELEMENT *);
extern "C" void		listMoveEnq (LIST *, LISTELEMENT *);
extern "C" void		listMovePush (LIST *, LISTELEMENT *);
extern "C" int		listLength (LIST *);


#else 


extern void		initializeList (LIST *);
extern void		initializeListElement (LISTELEMENT *, void *);
extern void		*listDeq (LIST *);
extern void		listEnq (LIST *, LISTELEMENT *);
extern void		listPush (LIST *, LISTELEMENT *);
extern void		listRemove (LISTELEMENT *);
extern void		listAppend (LIST *, LIST *);
extern void		listInsertAfter (LISTELEMENT *, LISTELEMENT *);
extern void		listInsertBefore (LISTELEMENT *, LISTELEMENT *);
extern void		listMoveEnq (LIST *, LISTELEMENT *);
extern void		listMovePush (LIST *, LISTELEMENT *);
extern int		listLength (LIST *);


#endif

/* END visible to E interpreter */
#endif __LIST_H__
#endif /* _LIST_H_ */
