#ifndef _MSGDEFS_H_
#define _MSGDEFS_H_
/*
 *   $RCSfile: msgdefs.h,v $  
 *   $Revision: 2.37 $  
 *   $Date: 1993/04/15 18:57:09 $      
 */ 
#ifndef __MSGDEFS_H__
#define __MSGDEFS_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	defines for the message passing subsystem
 */

#include "lock.h"
#include "tid.h"

/*
 *	define the path index type
 */
typedef FOUR	RESOURCEID;


/*
 *  used for the readv and writev which read/write from multiple
 *  memory buffers.  This sets the maximum number of buffers.
 */
#define MAX_IOVEC	4

#define IOVECENT struct iovec

typedef IOVECENT	IOVECTOR[MAX_IOVEC];


/*
 *	all messages must have this header
 */
typedef struct {
	SHORT_MAGIC		version;	/* it's worth shortening this up */
	UONE			type;
	BOOL			replyRequested;	/* should server reply	*/
	union {
		struct {
			TID				tid;
		} in;
		struct {
			FOUR			errno;
			FOUR			linkTransError; /* reason for last trans
											   abort (from client link
											   structure on server) */
			LSN				endOfLog;
		} out;
	} params;

} MSGHDR;


/* 
 * NB: increment this whenever the protocol changes
 */
#define MESSAGE_VERSION	((SHORT_MAGIC)0x96c9)

/*
 *	message type resource
 */
typedef struct {

	RESOURCEID		id;
	UNIQUE			unique;

} RESOURCEBODY;


/*
 *	message type for user block requests
 */
typedef struct {
	FID			fid; 
	LOCKMODE	fidLockMode;  
	LOCKMODE	pidLockMode;  
	PID			pid;          
} LOCKBODY;	

typedef struct {
	PID			pid;          
	TWO			page2size; 	  
	PAGETYPE	pageType;
	UONE		flags;    /* input/output parameter  - see also fi_msg.h */
#define			PAGE_IS_NEW			0x20
#define			REPLY_WITH_NEIGHBOR	0x40
#define			REPLY_WITH_DATA		0x80

	LRC			pageLRC;  /* input/output parameter */
	union {
		struct {
			LSN			__firstLSN;
			LRC			__firstLRC;     
#define FirstLSN  pageBodyUnion.writePageBody.__firstLSN
#define FirstLRC  pageBodyUnion.writePageBody.__firstLRC
		} writePageBody;
		struct {
			FID			__fid;
			LOCKMODE	__pidLockMode;  
			LOCKMODE	__fidLockMode;  /* input param - IO_ReadPage */
#define Fid             pageBodyUnion.readPageBody_in.__fid
#define PidLockMode     pageBodyUnion.readPageBody_in.__pidLockMode
#define FidLockMode     pageBodyUnion.readPageBody_in.__fidLockMode
		} readPageBody_in;
		struct {
			PID			__neighborPid;          
#define NeighborPid pageBodyUnion.readPageBody_out.__neighborPid
		} readPageBody_out;
	} pageBodyUnion;
} PAGEBODY;


/*
 *	message type for user block requests
 */
typedef struct {

	PID			pid;
	UNIQUE		unique;
	UFOUR		uniqueCount;

} UNIQUEBODY;


/*
 *	message type for user block requests
 */
typedef struct {

	FID			fid;
	PID			pid;
	FLAGS		flags;

} FILEBODY;


/*
 *	message type for user block requests
 */
typedef struct {

	FID			fid;
	PID			pid;
	PAGE2SIZE	page2size;
	FLAGS		flags;
	RESOURCEBODY	resource;

} SEQFILEBODY;


/*
 *	message type for user block requests
 */
typedef struct {

	FOUR			recordSize;
	FLAGS			flags;
	BOOL			eof;
	RESOURCEBODY	resource;

} SEQRECORDBODY;


/*
 *	message for page allocation
 */

typedef struct {
	VOLID		volid;
	TWO			page2size;
	TWO			numPages;
	TWO			pageType;
	UONE		flags;		/* on dealloc, 1 indicates immediate 	*/
	PID			nearPid;
	union {
		struct {
			FID			fid;
			UFOUR		uniqueCount;
		} s_input;
		struct {
			UNIQUE		unique;
			SHORTPID	logicalPredPid;
		} s_output;
	} slotted;
} ALLOCBODY;


typedef struct {

	PID			pid;
	int			pageType;
	BOOL		bitSet;

} CHECKBODY;


/*
 *	message type for disk requests
 */
typedef struct {

	/* char		volName[DEVNAMEMAX]; */ /* now separate data in msg */
	VOLID		volid;
	TWO			numCylinders;
	TWO			tracksPerCylinder;
	FOUR		pagesPerTrack;
	FOUR		numFreePages;
	FOUR		bitmapPages;
	FOUR		numPages;
	FOUR		logFileSize;
	TWO			logFileBlock2size;
	FLAGS		properties;

} STATVOLBODY;

typedef struct {
	int			optionNameLength; 
	int			formatLength;
	VOLID		volid;		  /* out  */
} VOLUMEBODY;

typedef struct {
	VOLID		volid;
	FLAGS		volumeProperties;

} MOUNTBODY;

typedef struct {
	int			operation; 
	/*  ADMIN_CLIENT_LOG_OFF, ADMIN_SETVAR */
	int			variable;
	int			value;
} ADMINBODY;


typedef struct {

	VOLID	volid;
	FOUR	dataSize;
	FOUR	nameSize;
	/* char	name[MAX_ROOTNAME_SIZE]; now separate data in message */
	/* char	data[MAX_ROOTDATA_SIZE]; now separate data in message */

} ROOTBODY;



typedef struct {

	BOOL	loggingOn;		/* TRUE = logging on for this transaction */
	TID		tid;			/* BEGIN_TRANS, ENTER_2PC return TID here */
	BOOL	syncTrans;		/* TRUE = flush all locked pages */
	int		lock_timeout;	/* # LOCK_WAIT_UNITs to await a lock;
							   units are defined in the server */

} TRANSBODY;

typedef struct {
	BOOL		initLRCisLSN;
	PAGE2SIZE	logPage2size;
	PAGE2SIZE	slottedPage2size;
	PAGE2SIZE	lgPage2size;
	PAGE2SIZE	lgDataPage2size;
	PAGE2SIZE	btreePage2size;
	PAGE2SIZE	indexDescPage2size;
	PAGE2SIZE	minPage2size;
	VOLID		volid;
	SHORT_MAGIC softwareVersion; /* so we do not have to recompile
								  * everything in order to change 
								  * compatibility 
								  * The value of this is in softwareVersion.h
								  */
} INITBODY;


typedef struct {

	PID		pid;
	FOUR	releaseLimit;
	FOUR	reserved;
	
} QUERYPAGEBODY;

typedef struct {

	FID     fid;
	FOUR    numPages;

} FILENUMPAGESBODY;


/*
 *	defines for administrative messages
 */

/*
 *	message type for user block requests
 */
typedef struct {

	FOUR	checkpointInterval;
	TWO		numCheckpoint;		/* take this many checkpoints */

} CHECKPNTBODY;

/*
 *	message for server shutdown (flags defined in adminmsg.h)
 */
typedef struct {

	FLAGS	shutdownFlags;

} SHUTDOWNBODY;

/*
 *	message for obtaining server statistics 
 *	(flags defined in adminmsg.h)
 */
typedef struct {

	FLAGS	flags;

} STATISTICSBODY;

/*
 *	for distr trans
 *	message for prepare requests from client to coordinator
 */
typedef struct {

	FOUR	numParticipants;
	BOOL	prepareAndCommit;

} PREPAREBODY;


/*
 *	for distr trans
 *	message for Enter2PC requests
 */
typedef struct {

	FOUR	length;

} ENTER2PCBODY;

/*
 *	for distr trans
 *	message for coordinator requesting the vote from a server 
 */
typedef struct {

	TID			coordTid;
	TID			localTid;
} VOTEREQBODY;

/*
 *	for distr trans
 *	message for returning the vote from a server to coordinator 
 *  and from the coord to the client
 */
typedef struct {

	TID			coordTid;
	TID			localTid;
	UONE		vote;	/* UONE should actually be VOTE */

} VOTEBODY;

/*
 *	for distr trans
 *	message for coordinator commanding server to commit/abort 
 *	or for client commanding coordinator to commit/abort 
 */
typedef struct {

	TID			coordTid;
	TID			localTid;
	UONE		command;	/* UONE should actually be COMMAND */

} COMMANDBODY;

/*
 *	for distr trans
 *	message for returning the ack from a server to coordinator 
 */
typedef struct {

	TID			coordTid;
	TID			localTid;

} ACKBODY;


typedef int DUMMYBODY;


/*
 *	union all the body types together
 */
typedef union {

	INITBODY		init;
	PAGEBODY		page;
	LOCKBODY		lock;
	ADMINBODY		admin;
	MOUNTBODY		mount;
	VOLUMEBODY		volume;
	STATVOLBODY		statvol;
	ALLOCBODY		alloc;
	CHECKBODY		check;
	UNIQUEBODY		unique;
	ROOTBODY		root;
	TRANSBODY		trans;
	FILEBODY		file;
	SEQFILEBODY		seqfile;
	SEQRECORDBODY	seqRecord;
	RESOURCEBODY	resource;
	QUERYPAGEBODY	lockQuery;
	FILENUMPAGESBODY fileNumPages;
	CHECKPNTBODY	checkpoint;
	SHUTDOWNBODY	shutdown;
	STATISTICSBODY	stats;
	PREPAREBODY     prepare;	/* for distr trans */
	ENTER2PCBODY    enter2pc;	/* for distr trans */
	VOTEREQBODY     voteReq;	/* for distr trans */
	VOTEBODY        vote;		/* for distr trans */
	COMMANDBODY     command;	/* for distr trans */
	ACKBODY         ack;		/* for distr trans */
	DUMMYBODY		dummy;

} MSGBODY;


typedef struct Message_s MESSAGE;

struct Message_s {

	MSGHDR		header;
	MSGBODY		body;

};


/*
 * definitions of message types are moved to msgstats.h!!!!!!!
 * msgstats.h also includes the msg stats structures and defs.
 * shared between client and server, and the common lib.
 */
#include "msgstats.h"

#endif __MSGDEFS_H__
#endif /* _MSGDEFS_H_ */
