#ifndef _OBJECT_H_
#define _OBJECT_H_
/*
 *   $RCSfile: object.h,v $  
 *   $Revision: 2.47 $  
 *   $Date: 1993/08/20 13:45:54 $      
 */ 
#ifndef __OBJECT_H__
#define __OBJECT_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/* BEGIN visible to user */

/*
 *	object.h
 *
 *		defines, typedefs, etc. used by object-level routines and
 *		clients of the storage manager.
 */

/*
 *	define the size of slotted pages
 */
#define SLOTTED_PAGE2SIZE	MIN_PAGE2SIZE
#define SLOTTED_PAGESIZE	(1 << SLOTTED_PAGE2SIZE)


/*
 *	define the sizes of large object pages
 */
#define LG_PAGE2SIZE	MIN_PAGE2SIZE
#define LG_PAGESIZE		(1 << LG_PAGE2SIZE)
#if	(MIN_PAGE2SIZE == 12)
#	define LGDATA_PAGE2SIZE	(MIN_PAGE2SIZE+1) /* double lg obj pages */
#else
#	define LGDATA_PAGE2SIZE	(MIN_PAGE2SIZE)   /* large obj pages == others */
#endif
#define LGDATA_PAGESIZE	(1 << LGDATA_PAGE2SIZE)
/*#define LGDATA_USABLESIZE is defined below */


/*
 *	define the sizes of btree pages
 */
#define BTREE_PAGE2SIZE		MIN_PAGE2SIZE
#define BTREE_PAGESIZE		(1 << BTREE_PAGE2SIZE)
#define INDEXDESC_PAGE2SIZE	MIN_PAGE2SIZE
#define INDEXDESC_PAGESIZE	(1 << INDEXDESC_PAGE2SIZE)

/*
 *	define the number of uniques allocated when page is created
 *	(100 per every 4K of pagesize)
 */
#if SLOTTED_PAGE2SIZE < 12
#define UNIQUE_ALLOC_COUNT	(100)
#else
#define UNIQUE_ALLOC_COUNT	(100+100*(SLOTTED_PAGE2SIZE-12))
#endif

    
/*
 *	Typedef for object addresses.
 */
typedef struct OBJADDR {

    SHORTPID	page;			/* the page address of the object's header	*/
    SLOTINDEX	slot;			/* slot number of the object				*/
	VOLID		volid;			/* the id of the volume						*/
	UNIQUE		unique;			/* unique number of the object				*/

} OBJADDR;


/*
 * Typedef for object ids.
 */
typedef struct OID {

    OBJADDR  diskAddr;			/* the object's disk address	*/

} OID;


/* END visible to user */


/*
 *	Typedef for object ids.
 */
typedef struct INTOID {

    OBJADDR		diskAddr;		/* the object's disk address	*/
    SHORTPID	fid;			/* the object's file id			*/

} INTOID;


/* BEGIN visible to user */

/*
 *	Defines for near in CreateObject call.
 */
#define NEAR_OBJ  			1
#define NEAR_FIRST			2
#define NEAR_LAST			3
#define NEAR_DISTINGUISHED	4	/* not used */
/* for backward compatibility */
#define NEAR_FIRST_PHYSICAL	NEAR_FIRST
#define NEAR_LAST_PHYSICAL	NEAR_LAST	
#define NEAR_FIRST_LOGICAL	NEAR_FIRST
#define NEAR_LAST_LOGICAL	NEAR_LAST


/*
 *	Typedef for generic object headers as viewed by clients of the storage manager.
 *	Note that the fields must match the initial fields of SMALLOBJHDR 
 *	and LARGEOBJHDR (all the same for now).
 */
typedef struct OBJHDR {

    TWO			properties;		/* the properties bit vector	*/
    TWO			tag;			/* the object's tag				*/
    FOUR		size;			/* the object's data size		*/

	/* MUST MAINTAIN 8-byte ALIGNMENT HERE: if you change this 
	 * the size of the OBJHDR, you might have to add a filler
	 * to maintain 8-byte alignment e.g.
		FOUR		filler;		
	 */

#if OBJECT_MAGIC IS_ENABLED
	MAGIC		magic;
#if (ALIGNON == 8)
	FOUR		filler;		
	/* no alignment needed */
#elif (ALIGNON == 4)
	/* no alignment needed */
#else
	not implemented
#endif
#endif OBJECT_MAGIC IS_ENABLED


} OBJHDR;


#define OBJECT_HDR_MAGIC		0x8AC429DA


/* END visible to user */

/* BEGIN visible to E */

/* 
 *	Typedef for small objects.
 */
typedef struct SMALLOBJ {

    OBJHDR	objectHdr;				/* the object's header	*/
    char	data[ALIGNSIZE(sizeof(SHORTPID))]; 	/* data area */
	/*
	 *	Making the data array larger is required to enforce the
	 *	requirement that small objects at least be large enough to
	 *	hold a large object header (LARGEOBJHDR).  
	 */
} SMALLOBJ;


/* 
 *	Typedef for generic object.
 *	This is used to determine what type of object we are dealing with.
 *	Once the object type is determined, then either the SMALLOBJ or
 *	LARGEOBJ typedef is used, depending, of course, on whether we are
 *	dealing with a large or small object.  For now the basic structure
 *	of an object is that of a small object.  In case of a large object
 *	the data area is used to hold control information.
 */
typedef SMALLOBJ OBJECT;

/* END visible to E */

/*
 * ------- LARGE OBJECT DEFINITION STUFF ----------
 */

/*
 *	Format of (count, page-pointer) pair for internal nodes.
 */
typedef struct LGSLOT {

    PID     pid;        /* pointer to root of child					*/
	BOOL	shared;		/* true if page is shared by another version*/
    FOUR    count;		/* child's byte count						*/

} LGSLOT;


/*
 *	Lower the fanout of lg obj btree nodes by defining LGTESTING
 */
#define NOLGTESTING

#ifdef LGTESTING


#define LGMAXSLOTS		5
#define LGMINSLOTS		((LGMAXSLOTS - 1) / 2)

#define LGMAXLEAF		16
#define LGMINLEAF		(ALIGNSIZE(LGMAXLEAF / 2))

#define LGMAXPAGESLOTS	6	
#define LGMINPAGESLOTS	((LGMAXPAGESLOTS - 1) / 2)


#else


#define LGMAXSLOTS		((LG_PAGESIZE - sizeof(LGNODEHDR)) / sizeof(LGSLOT))
#define LGMINSLOTS		((LGMAXSLOTS - 1) / 2)

#define LGMAXLEAF		LGDATA_USABLESIZE
#define LGMINLEAF		(ALIGNSIZE(LGMAXLEAF / 2))

#define LGMAXPAGESLOTS	24	
#define LGMINPAGESLOTS	((LGMAXPAGESLOTS - 1) / 2)


#endif


/*
 *	"Pointer" to a version history graph node
 */
typedef struct VHGNODEPTR {
	OID			oid;	/* object containing the version graph	*/
	VHGNODEID	nodeId;	/* node in the graph for this large obj	*/
} VHGNODEPTR;

/*
 *	define the header field of a large object node
 */
typedef struct LGNODEHDR {

	MAGIC		magic;					/* magic number for			*/

    ONE			height;					/* distance to leaf nodes	*/
    TWO			numSlots;				/* number of slots in node	*/

	VHGNODEPTR	vhgPtr;					/* Version history graph node
										   for this large object 	*/
	/*
	 *	The vhgPtr field would be best be located in the large object
	 *	header, but this would require the minumum size of small 
	 *	objects to be significantly larger.  Therefore it is placed
	 *	here.  Only the root page header will contain a valid
	 *	VHGNODEPTR.
	 */

	LRC			lrc;						/* lrc for node pages		*/

} LGNODEHDR;


/*
 *	Internal node format (also root format for now).
 */
typedef struct LGNODE {

	LGNODEHDR	header;					/* header of the node			*/
    LGSLOT		slot[LGMAXSLOTS];		/* array of slots themselves	*/

} LGNODE;


/*
 *	define the magic number for the large object pages
 */
#define LARGENODE_MAGIC		0x40237819


/*
 *	Internal node format (also root format for now).
 */
typedef struct LGSLOTROOT {

	LGNODEHDR	header;					/* header of the node			*/
    LGSLOT		slot[LGMAXPAGESLOTS];	/* array of slots themselves	*/

} LGSLOTROOT;


#define SLOTROOT_MAGIC	0x345aedf7

/*
 *	Typedef for large objects with root on seperate page.
 */
typedef struct LARGEOBJHDR {

    OBJHDR		objectHdr;	/* the object's header					*/
   	SHORTPID	rootPid;	/* the page id of the object's root 	*/
	/*
	 *	If fields are changed here, see the definition of 
	 *	SMALLOBJ so that the minumum size of a small object is
	 *	large enough to hold a LARGEOBJHDR.
	 */

#if (ALIGNON == 8)
	FOUR		filler;			/* to give 8 byte alignment		*/
#elif (ALIGNON == 4)
	/* no alignment needed */
#else
	not implemented
#endif

} LARGEOBJHDR;


/*
 *	Typedef for large objects with root on slotted page
 */
typedef struct LARGEOBJROOT {

    OBJHDR			objectHdr;		/* the object's header			*/
	LGSLOTROOT		rootPage;		/* the root on the slotted page	*/

} LARGEOBJROOT;


/*
 *	Header for large object data page
 */
typedef struct LGDATAHDR {

	LRC		lrc;
	MAGIC	magic;

#if (ALIGNON == 8)
	FOUR		filler;			/* to give 8 byte alignment		*/
#elif (ALIGNON == 4)
	/* no alignment needed */
#else
	not implemented
#endif

} LGDATAHDR;

#define LGDATAHDR_MAGIC		0xf111111f

/*
 *	Available space for data on large object data page
 */
#define LGDATA_USABLESIZE	(LGDATA_PAGESIZE - sizeof(LGDATAHDR))

/*
 *	large object data page
 *	It is important to have the header at the end of the page so
 *	that it will be overwritten when the pages are placed 
 *	contiguously.
 */
typedef struct LGDATAPAGE {
	
	char		data[LGDATA_USABLESIZE];
	LGDATAHDR	header;

} LGDATAPAGE;


/* BEGIN visible to user */
/*
 *	Properties bits; only a few for now.
 */
#define P_LARGEOBJ		0x1		/* whether this is a large object		*/
#define P_HEADERONPAGE	0x2		/* large object header is on the page	*/
#define P_PAGESIZEOBJ	0x4		/* whether this is a page size object	*/
#define P_MOVED			0x8		/* object has been moved to a new page	*/
#define P_FORWARD		0x10	/* this is the forwarded record			*/
#define P_VERSIONED		0x20	/* object is versioned			  	 */
#define P_FROZEN		0x40	/* object is frozen version			 */
#define P_HISTORYGRAPH	0x80	/* object is a version history graph */
#define P_DESTROYPENDING	0x100	/* object is marked to be destroyed
									   pending freezing of all working i
									   verions */
#define P_INDEX			0x200	/* object is an index	 		  	 */
#define P_CREATEINPROGRESS	0x400	/* object is process of being created.
										used for logging lg obj creates. */

/*
 *	define a type for a slot that includes a unique number
 */
typedef struct  PAGESLOT {

	FOUR	offset;
	UNIQUE	unique;

} PAGESLOT;


/*
 *	Define a header for the slotted page
 */
typedef struct SLOTTEDHEADER {

    SLOTINDEX  	slotCount;			/* slots in use on the page				*/
	SLOTINDEX	freeSlot;			/* list of free slots					*/
	LRC			lrc;				/* lrc for logging						*/
    FOUR     	freeStart;			/* offset of contig free area on page	*/
    FOUR     	freeBytes;			/* free bytes in the page				*/
    PID     	pid;				/* the page's pid						*/
    FID     	fid;				/* the file the page belongs to			*/
    PID     	neighborPid;		/* the neighboring page Pid				*/
	SHORTPID	nextLogicalPid;		/* used for logical sequence sets		*/
    FOUR    	largeCount;			/* marked if the page has large obj		*/
	UNIQUE		unique;				/* current unique value					*/
	FOUR		uniqueCount;		/* limit of unique values				*/
	MAGIC		magic;

} SLOTTEDHEADER;


/*
 *	Amount of contiguous free space initially on page.
 */
#define INITIALLYFREE	(SLOTTED_PAGESIZE - sizeof(SLOTTEDHEADER))

/*
 *	the definition of a page
 */
typedef struct SLOTTEDPAGE {

    char			data[INITIALLYFREE - sizeof(PAGESLOT)];	/* the data region	*/
    PAGESLOT		slot[1];			/* slot array, indexes backwards		*/
	SLOTTEDHEADER	header;				/* header of the slotted page			*/

} SLOTTEDPAGE;


#define SLOT_PAGE_MAGIC			0xb1a5dccb


/* 
 *	Maximum number of slots on a page.
 */
#define MAXPAGESLOTS	((SLOTTED_PAGESIZE - sizeof(SLOTTEDHEADER)) / sizeof(PAGESLOT))


/*
 *	Define for the threshold at which a new object starts life as
 *	a large object rather than a small object.  This must be defined
 *	to include the size of the small object header.
 */
#ifdef LGTESTING
#	define LARGETHRESHOLD	LGMAXLEAF
#else
#	define LARGETHRESHOLD	\
		(SLOTTED_PAGESIZE - (sizeof(SLOTTEDHEADER) + sizeof(PAGESLOT) + sizeof(OBJHDR)))
#endif


/*
 *	define the largest large object that will fit in a tree with
 *	the root on a slotted page
 */
#define LSLOTTHRESHOLD		(LGMAXPAGESLOTS * LGMAXLEAF)


/*
 *	define some state variables for checking for free space
 */
#define PAGE_NO_SPACE		0x0
#define PAGE_LAST_SLOT		0x1
#define PAGE_INT_SLOT		0x2


/*
 *	define the hash function for hashing an oid
 */
#define BF_HashOid(_oid)								\
	((_oid)->diskAddr.unique & ObjectHashMask)



#define INIT_LARGENODE_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = LARGENODE_MAGIC;			
	
#define INIT_LGDATAHDR_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = LGDATAHDR_MAGIC;			
	
#define INIT_SLOTROOT_MAGIC(_nodePtr)					\
														\
	(_nodePtr)->header.magic = SLOTROOT_MAGIC;			

	
/*
 *	define a check for a large node magic number
 */
#define CHECK_LARGENODE_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != LARGENODE_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}
	

/*
 *	define a check for a large data magic number
 */
#define CHECK_LGDATAHDR_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != LGDATAHDR_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}
	

/*
 *	define a check for a large node magic number
 */
#define CHECK_SLOTROOT_MAGIC(_nodePtr)					\
														\
	if ((_nodePtr)->header.magic != SLOTROOT_MAGIC)	{	\
		SM_ERROR(TYPE_FATAL, esmINTERNAL);				\
	}


/*
 *	define index descriptor stuff
 */

#define SM_MAXELEMLEN   20      /* range 4--124 (multiples of 4) */

typedef enum { SM_BTREENDX, SM_HASHNDX } SMTYPE;

typedef enum { SM_EQ = 1, SM_G = 2, SM_L = 4,
				SM_GEQ = 3, SM_LEQ = 5 } SMCOND;

#define SM_BOF	NULL, SM_GEQ
#define SM_EOF	NULL, SM_LEQ

typedef enum { SM_char, SM_int, SM_long, SM_short, SM_float, 
				SM_double, SM_string } SMDATATYPE;
#define SM_Boolean SM_char

/* END visible to user */



#define NDXMAGIC 	0x140267
typedef struct INDEXDESC {
		SMTYPE		ndxType;		/* index type */
		PID			rootPid;		/* root page ID */
		TWO			maxKeyLen;		/* maximum length of key */
		TWO			elSize;
		SMDATATYPE	dataType;
		ONE			unique;			/* TRUE if index is unique */
} INDEXDESC;
		
typedef struct INDEXDESCPAGE {
		FOUR		magic;
		LRC			lrc;
		INDEXDESC	desc;
} INDEXDESCPAGE;
		

/* BEGIN visible to user */

typedef struct IID {
		PID 	pid;
} IID;					/* INDEX IDENTIFIER */

#ifdef __cplusplus
#ifdef PIDEQ
inline operator ==(const IID& i1, const IID& i2) {
		return PIDEQ(i1.pid, i2.pid);
		}
inline operator !=(const IID& i1, const IID& i2) {
		return ! (i1 == i2);
		}
#endif PIDEQ
#endif __cplusplus

#define PFCDEFINED
#ifdef __cplusplus
typedef int 	(*PFC) PROTO((int kLen1, const void* kVal1, 
									int kLen2, const void* kVal2));
#else
typedef int 	(*PFC) PROTO((int kLen1, void* kVal1, int kLen2, void* kVal2));
#endif

typedef void    (*PFK) PROTO((int kLen, char* kVal));


/* END visible to user */

extern PFC SMCOMPFUNC [ SM_string + 1];


#endif __OBJECT_H__
#endif /* _OBJECT_H_ */
