#ifndef __PAGE_H__
#define __PAGE_H__
/*
 *   $RCSfile: page.h,v $  
 *   $Revision: 2.6 $  
 *   $Date: 1992/09/11 16:09:29 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/


/*
 * Basic uninterpreted page type.
 */
typedef union {
    char	ch[MIN_PAGESIZE];
} PAGE;


/*
 * PID macros.
 */
#define	PIDEQ(_a,_b)							\
	    ((_a).page  == (_b).page && (_a).volid == (_b).volid)
#define	PPIDEQ(_a,_b)							\
		(((_a)->page  == (_b)->page) && ((_a)->volid == (_b)->volid))


#define	PIDCLEAR(_a)							\
	    (_a).page= -1;(_a).volid= -1

#define	TESTPIDCLEAR(_a)							\
	    ((_a).page == -1 && (_a).volid == -1)

#define	PRINTPID(_a)							\
	    printf("{volid=%d, page=%d}", (_a).volid, (_a).page)

#define	PRINTPIDPTR(_a)							\
	    if ((_a)==NULL) {printf("NULL");} else { PRINTPID(*(_a));}
#endif __PAGE_H__
