#ifndef _SM_MACRO_H_
#define _SM_MACRO_H_
/*
 *   $RCSfile: sm_macro.h,v $  
 *   $Revision: 2.11 $  
 *   $Date: 1992/11/27 16:46:23 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/* BEGIN visible to E */

/*
 * sm_macro.h
 * 	macros for the sm module.
 */


/*
 * Macro to initialize a slotted page.
 */
#define INITPAGE(_pagePtr, _pid, _fid, _marked, _unique)		\
		(_pagePtr)->header.freeStart		 = 0;							\
		(_pagePtr)->header.freeBytes		 = INITIALLYFREE;				\
		(_pagePtr)->header.freeSlot			 = NIL;							\
		(_pagePtr)->header.slotCount		 = 0;							\
		(_pagePtr)->header.pid				 = _pid;						\
		(_pagePtr)->header.fid				 = _fid;						\
		(_pagePtr)->header.neighborPid.volid = NIL;							\
		(_pagePtr)->header.nextLogicalPid	 = NULLPID;						\
		(_pagePtr)->header.largeCount		 = (_marked) ? 1 : 0;			\
		(_pagePtr)->header.uniqueCount		 = UNIQUE_ALLOC_COUNT;			\
		(_pagePtr)->header.unique			 = _unique;						\
		(_pagePtr)->header.magic			 = SLOT_PAGE_MAGIC;				\
		(_pagePtr)->slot[0].offset			 = NIL;


/*
 * Macro to calculate the amount of continguous free space on a slotted page.
 */
#define CONTIGSPACE(_pagePtr)												\
			((int)sizeof(SLOTTEDPAGE) - ((_pagePtr)->header.freeStart +					\
			(int)sizeof(SLOTTEDHEADER) + ((_pagePtr)->header.slotCount * (int)sizeof(PAGESLOT))))

/*
 *	macro to get a pointer to the slot
 */
#define GETSLOTPTR(_pagePtr, _slotIndex)			\
		(&((_pagePtr)->slot[-(_slotIndex)]))

/*
 * Macro to calculate the address of a generic object on
 * a slotted page.
 */
#define GETOBJECTPTR(_pagePtr, _slotPtr)						\
	    ((OBJECT *) ((char *) (_pagePtr) + ((_slotPtr)->offset)))

/*
 * Macro to calculate the address of an small object on
 * a slotted page.
 */
#define SMALLOBJPTR(_pagePtr, _slot)					\
	    ((SMALLOBJ *) ((char *) _pagePtr + (_pagePtr)->slot[-_slot]))

/*
 * Macro to calculate the address of an large object on
 * a slotted page.
 */
#define LARGEOBJPTR(_pagePtr, _slot)					\
	    ((LARGEOBJ *) ((char *) _pagePtr + (_pagePtr)->slot[-_slot]))


/*
 * Macro to check if we have a valid oid.
 */
#define CHECKOID(_objSlot, _pagePtr, _slotPtr, _unique)				\
																	\
	    ((_objSlot < 0) ||											\
		(_objSlot >= (_pagePtr)->header.slotCount) ||				\
		(_slotPtr->offset == NIL) ||								\
		(_slotPtr->unique != _unique))


#define	OIDEQ(_oid1, _oid2) 										\
		( ((_oid1).diskAddr.unique 	== (_oid2).diskAddr.unique) &&	\
		  ((_oid1).diskAddr.slot 	== (_oid2).diskAddr.slot) &&	\
		  ((_oid1).diskAddr.page 	== (_oid2).diskAddr.page) &&	\
		  ((_oid1).diskAddr.volid	== (_oid2).diskAddr.volid) )


#define CHECK_SLOTTED_MAGIC(_slottedPage)				\
														\
	((_slottedPage)->header.magic != SLOT_PAGE_MAGIC)


/*
 *	Objects with these flags set are invisible to the user
 */
#define INVISIBLE_OBJECT (P_HISTORYGRAPH | P_FORWARD | P_DESTROYPENDING)

/* END visible to E */

/* BEGIN visible to user */
/*
 *	define flags for opening a buffer group
 */
#define TRANS_GROUP		0x1
/* END visible to user */
#endif /* _SM_MACRO_H_ */
