#ifndef __TRANS_STATES_H__
#define __TRANS_STATES_H__
/*
 *   $RCSfile: trans_states.h,v $  
 *   $Revision: 1.1 $  
 *   $Date: 1992/11/19 05:57:33 $      
 */ 
/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/

/*
 *	Define the states of a transaction
 *  Some of these are not used on the client side. 
 */
#define	T_INACTIVE		0	/* not in use; forgotten          */
#define T_ACTIVE		1	/* in use                         */
#define T_LATENT		2 	/* internal abort                 */
#define T_QUIESCE		3	/* after commit, quiesce          */
#define T_COMMIT		4	/* commit record was written      */
#define T_ABORT			5	/* aborted by SM, not by user     */
#define T_RECOVER		6   /* being recovered (not a new tx) */
#define T_PREPARED		7   /* prepared to commit 		      */
#define T_END			8   /* after all acks are in 		  */

#endif __TRANS_STATES_H__
