#ifndef _VERSION_GRAPH_H_
#define _VERSION_GRAPH_H_
/*
 *   $RCSfile: version_graph.h,v $  
 *   $Revision: 2.7 $  
 *   $Date: 1992/11/27 16:46:27 $      
 */ 
#ifndef __VERSION_GRAPH_H__
#define __VERSION_GRAPH_H__

/**********************************************************************
* EXODUS Database Toolkit Software
* Copyright (c) 1991 Computer Sciences Department, University of
*                    Wisconsin -- Madison
* All Rights Reserved.
*
* Permission to use, copy, modify and distribute this software and its
* documentation is hereby granted, provided that both the copyright
* notice and this permission notice appear in all copies of the
* software, derivative works or modified versions, and any portions
* thereof, and that both notices appear in supporting documentation.
*
* THE COMPUTER SCIENCES DEPARTMENT OF THE UNIVERSITY OF WISCONSIN --
* MADISON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.  
* THE DEPARTMENT DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY DAMAGES
* WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
*
* The EXODUS Project Group requests users of this software to return 
* any improvements or extensions that they make to:
*
*   EXODUS Project Group 
*     c/o David J. DeWitt and Michael J. Carey
*   Computer Sciences Department
*   University of Wisconsin -- Madison
*   Madison, WI 53706
*
*	 or exodus@cs.wisc.edu
*
* In addition, the EXODUS Project Group requests that users grant the 
* Computer Sciences Department rights to redistribute these changes.
**********************************************************************/
/*
 * Declarations of various data structures used to for version history
 * graphs (VHG's).
 */

/*
 * Version history graph node id.
 */
/* defined in ess.h */

/*
 *	NULL VHG node id
 */
#define VHGNULLNODE	0xffffffff


/*
 *	This describes a "pointer" in a version history graph.  This
 * 	is an offset in bytes from beginning of the version graph.
 */
typedef FOUR VHGPTR ;

/*
 * List header for lists of version history graph nodes
 */
typedef struct {
	VHGPTR 	succ;
	VHGPTR	pred;
	VHGPTR	item;
	MAGIC				magic;

} VHGNODELIST;

/*
 * Elements (links) in VHG node lists
 */
typedef VHGNODELIST 	VHGNODELISTELEMENT;

/*
 * Magic number for lists in version history graphs
 */
#define VHGLIST_MAGIC	0xa68f34c1


/*
 * Flags representing various states of a node
 */
typedef UONE VHGNODEFLAGS;
#define	V_destroy_pending	0x1
#define	V_frozen 			0x2
#define	V_tombstone			0x4


/*
 * VHG node
 */
typedef struct {
	VHGNODEID			id;
	VHGNODEID			parentId;
	VHGNODELIST			children;
	VHGNODELISTELEMENT  siblings;
	OID					oid;		/* object whose version is 	*/
									/* represented by this node */
 	VHGNODEFLAGS		flags;		/* current state of node 	*/	
	MAGIC				magic;
} VHGNODE;


/*
 * Magic number for history graph nodes
 */
#define VHGNODE_MAGIC	0xd47a23b9

/*
 * Initial starting size for the free list of nodes for a graph
 */
#define VHGINITSIZE 3


/*
 * Version history graph.
 */
typedef struct {
	int			nodeCount;			/* current size of node array	*/
	VHGNODEID	root;				/* root of the graph 			*/
	VHGNODELIST	freeList;			/* list of free nodes			*/
	MAGIC				magic;
	VHGNODE		nodeArray[VHGINITSIZE];	/* variable length array	*/
} VERSIONGRAPH;

/*
 * Magic number for version history graphs
 */
#define VERSIONGRAPH_MAGIC	0x3d2da41b


/********************************************************************/

/*
 *	VHG Macros
 */

/*
 * Header properties macros
 */
#define WORKING_VERSION(_properties) 								\
	( (_properties & P_VERSIONED) && !(_properties & P_FROZEN) )

/*
 * 	Null VHG pointers
 */
#define VHGPTR_SET_NULL(_vhgPtr)									\
	(_vhgPtr)->oid.diskAddr.volid = 0;

#define VHGPTR_IS_NULL(_vhgPtr)										\
	((_vhgPtr)->oid.diskAddr.volid == 0)

/*
 *  define the magic checking macros
 */

#if MAGIC_CHECKING IS_ENABLED


#define INIT_VHGNODE_MAGIC(_vhgNode)                		\
                                                            \
    (_vhgNode)->magic = VHGNODE_MAGIC;

#define INIT_VERSIONGRAPH_MAGIC(_versionGraph)              \
                                                            \
    (_versionGraph)->magic = VERSIONGRAPH_MAGIC;

#define INIT_VHGLIST_MAGIC(_vhgList)              \
                                                            \
    (_vhgList)->magic = VHGLIST_MAGIC;


#define CHECK_VHGNODE_MAGIC(_vhgNode)                     	\
                                                            \
    if ((_vhgNode)->magic != VHGNODE_MAGIC)   {           	\
                                                            \
        SM_ERROR(TYPE_FATAL, esmINTERNAL);                  \
    }

#define CHECK_VERSIONGRAPH_MAGIC(_versionGraph)            \
                                                            \
    if ((_versionGraph)->magic != VERSIONGRAPH_MAGIC)   {  \
                                                            \
        SM_ERROR(TYPE_FATAL, esmINTERNAL);                  \
    }

#define CHECK_VHGLIST_MAGIC(_vhgList)            \
                                                            \
    if ((_vhgList)->magic != VHGLIST_MAGIC)   {  \
                                                            \
        SM_ERROR(TYPE_FATAL, esmINTERNAL);                  \
    }


#else

#define INIT_VHGNODE_MAGIC(x)
#define INIT_VERSIONGRAPH_MAGIC(x)
#define INIT_VHGLIST_MAGIC(x)

#define CHECK_VHGNODE_MAGIC(x)
#define CHECK_VERSIONGRAPH_MAGIC(x)
#define CHECK_VHGLIST_MAGIC(x)

#endif
#endif __VERSION_GRAPH_H__
#endif /* _VERSION_GRAPH_H_ */
