BEGIN {OFS="\t"; }
/^#define/ { if ( NF > 1 ) print $2,FILENAME, NR; }
/^[ 	]*const[ 	][ 	]*.*;$/ {
	for (x = 1; x <= NF; ++x) {
		if ($x == "=") { y = x-1; print $y,FILENAME,NR; } 
	}
}
/^[ 	]*typedef[ 	][ 	]*.*;$/ {
	x = NF; l=length($x);
	if(l==1) {
		x = NF-1; print $x,FILENAME,NR;
	} else {
		print substr($x, 1, l-1), FILENAME,NR;
	}
}
/struct[ 	][ 	]*[a-zA-Z_0-9]*[ 	][	 ]*{/ {
	if ( NF == 3 ) print $2,FILENAME,NR; else {
		for (x = NF; x > 0; --x) {
			if ($x == "struct") { y = x+1; print $y,FILENAME,NR; }
		} 
	}
}
/class[ 	][ 	]*[a-zA-Z_0-9]*[ 	][ 	]*{/ { 
	if ( NF == 3 ) print $2,FILENAME,NR; else { 
		for (x = NF; x > 0; --x) { 
			if ($x == "class") { y = x+1; print $y,FILENAME,NR; } 
		} 
	} 
}
