#include "et.h"
#include "etError.h"
#include "func.h"

#ifndef DEBUG
#define bf_CountFixed() 0
#define bf_PrintFixed() 
#endif DEBUG

static int lastBufs = -1;
static int lastCheckedLine	= -1;
static char *lastCheckedFile = NULL;

void
printBufs()
{
	int nb = bf_CountFixed();
	bf_PrintFixed();
	fprintf(stderr, "TOTAL TOTAL FIXED CHARGES: %d\n", nb);
}/* getNumBufs */

int
getNumBufs()
{
	return bf_CountFixed();
}/* getNumBufs */

void
compareNumBufs(int line, char *file, int oldval, char *str)
{
	register int diff;

	diff = getNumBufs() - oldval;
	if(diff != 0) {
		fprintf(stderr, 
			"%s FATAL ERROR: BUFFER LEAK! %s %d bufs at line %d, file %s\n",
			str,
			(diff > 0)?"FIXED":"UNFIXED",
			(diff > 0)?diff:(0-diff), line, file);
		printBufs();
		exit(EXIT_VALIDATIONERR);
	}
}

void
checkNumBufs(int line, char *file, BOOL reset)
{
	int diff;

	if	(!reset)  {
		diff = getNumBufs() - lastBufs;
		if(diff != 0) {
			fprintf(stderr, 
		"WARNING: BUFFER LEAK! %s %d bufs between line %d %s and line %d %s\n",
				(diff > 0)?"FIXED":"UNFIXED",
				(diff > 0)?diff:(0-diff), lastCheckedLine, lastCheckedFile,
				line, file);
			printBufs();
			/*
			exit(EXIT_VALIDATIONERR);
			*/
		}
		/* keep going */
	}
	lastBufs = getNumBufs(); 
	lastCheckedLine = line;
	lastCheckedFile = file;

	{
		char xxx[100];
		extern int checkMalloc(char *, BOOL);

		sprintf(xxx, "checkNumBufs from %d %s", line, file);
		(void) checkMalloc(xxx, !reset);
	}
}

static int lastTidMalloc	= 0;
static TID lastTidChecked = NULL_TID;
static int lastTidBufs = 0;

void
begin_tx_bufs(TID tid)
{
	lastTidChecked = tid;
	lastTidBufs = getNumBufs();
	lastTidMalloc = checkMalloc("begin_tx",  FALSE);

	fprintf(stderr, "BEGIN TID %d: %d buffers, %d bytes\n", 
		tid, lastTidBufs, lastTidMalloc);
}

void
end_tx_bufs(TID tid)
{

	char xxx[100];

	sprintf(xxx, "END TID %d", tid);
	if( lastTidChecked == tid) {
		int n;

		compareNumBufs(__LINE__,__FILE__, lastTidBufs, xxx);
		n = checkMalloc(xxx,  FALSE);

		if(n > lastTidMalloc) {
			fprintf(stderr, "%s ALLOCED %d: ", xxx, n-lastTidMalloc);
			(void) mstats(xxx,1);
		} else if(n < lastTidMalloc) {
			fprintf(stderr, "%s FREED %d: ", xxx, lastTidMalloc-n);
		}
	}
}

#if	!defined(mips) || !defined(CHECKMALLOC)
int	 	mstats(char *, int ) { return 0; }
#endif 
