/*
 * $RCSfile: scanFile.c,v $
 * $Revision: 1.7 $
 * $Date: 1993/04/28 20:01:41 $
 */
#include <stdio.h>
#include <setjmp.h>
#include "et.h"
#include "etError.h"
#include "func.h"


/********************************************************
 *
 *      scanFile
 *
 *******************************************************/

int scanFile(FID *fid, BOOL temp, BOOL readAll, BOOL appendUA, ObjInfo *array, int arraysize)
{
	int				count;
	int				e;
	SCANDESC        *scanDesc;
	BOOL            eof;
	USERDESC        *userDesc;
	int				amount;

	set_retry();
again:
	count = 0; e = 0; scanDesc=NULL; userDesc= NULL; eof = FALSE;

	checkNumBufs(__LINE__, __FILE__, TRUE);
	/*
	 * appendUA true <--> array == NULL
	 */
	if(appendUA) {
		readAll = TRUE; /* regardless of the input arg */
	} else
		clear_visited(array, arraysize);

	if(readAll)
		amount = READ_ALL; 
	else
		amount = 0; /* get the hdr only */


	DEBUGINFO
		"scan file %d.%d.%d\n", fid->pid.page, fid->pid.volid, fid->unique
	ENDINFO

	if ((e = sm_OpenScanWithGroup(fid, PHYSICAL_SCAN, bufGroup, &scanDesc, NULL)) != esmNOERROR) {
		if((sm_errno == esmBADFID) && temp) {
			/* for use with temp volumes - 
				files don't exist after a commit so this error is ok */
			DEBUGINFO
				"file does not exist"
			ENDINFO
			return 0;
		}
		HANDLE_ERROR(CAUSE_SM, TREAT_INFO, SM_OPENSCAN_ERR);
		count = -1;
		goto bye2;
	}
	DEBUGINFO
		"scan file %d.%d.%d line %d\n", 
		fid->pid.page, fid->pid.volid, fid->unique, __LINE__
	ENDINFO

	eof = FALSE;

	DEBUGINFO 
		"Scanning all objects in the file %d.%d.%d\n", fid->pid.page, fid->pid.volid, fid->unique
	ENDINFO

	while (!eof) {
		sm_errno = 0;
		if ((e = sm_ScanNextObject(scanDesc, 0, amount, &userDesc, &eof))
							!= esmNOERROR) {
			HANDLE_ERROR(CAUSE_SM, TREAT_INFO, SM_OPENSCAN_ERR);
			count = -1;
			goto bye;
		}

		/* a bit of verifying  sm_* interface... */
		if (userDesc == NULL) {
			if((eof != TRUE) && (amount != 0)) {
				HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, SM_SCANNEXTOBJ_ERR);
				count = -1;
				goto bye;
			}
		}
		/* a bit more verifying  sm_* interface... */
		if (eof) {
			if(userDesc != NULL) {
				HANDLE_ERROR(CAUSE_VALIDATION, TREAT_FATAL, SM_SCANNEXTOBJ_ERR);
				count = -1;
				goto bye;
			}
		}

		if (eof) {
			/* ok - no more objects, so break out of loop */
			break;
		}

		if(interactive) {
			DEBUGINFO
				"read OBJ-%d %1.*s,\t size:%d\n",
				 userDesc->tag, userDesc->objectSize, userDesc->basePtr,
				userDesc->objectSize
			ENDINFO
		}

		if(appendUA) {
			UA[objUACount].objID = userDesc->oid;
			if (sm_ReadObjectHeader(bufGroup, &UA[objUACount].objID, &UA[objUACount].objHdr)) {
				HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, SM_READ_OBJ_HEADER_ERR);
				count = -1;
				goto bye;
			}
			fillUA(UA, objUACount, 
				checkSum(userDesc->basePtr, userDesc->objectSize), -1);
			objUACount++;
		} else {
			ObjInfo *objinfo;
			objinfo = oid2objinfo(&userDesc->oid, array, arraysize);
			if(objinfo) {
				set_visited(objinfo);
			} else {
				INFO
					"No objinfo for object %d.%d.%d.%d in file %d.%d.%d\n",
					userDesc->oid.diskAddr.page,
					userDesc->oid.diskAddr.volid,
					userDesc->oid.diskAddr.slot,
					userDesc->oid.diskAddr.unique,
					fid->pid.page,
					fid->pid.volid, fid->unique
				ENDINFO
				HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, NOINFO);
				count = -1; 
				goto bye;
			}
		}

		count++;

		{	/* check sm_* interface correctness */
			USERDESC *userDescAux;

			if ((e = sm_ReadObject(bufGroup, &userDesc->oid, 0, 0, &userDescAux))
								!= esmNOERROR) {
				HANDLE_ERROR(CAUSE_SM, TREAT_FATAL, SM_READ_OBJ_ERR);
				count = -1;
				goto bye;
			}
			if((e = sm_ReleaseObject(userDescAux)) != esmNOERROR) {
				HANDLE_ERROR(CAUSE_SM, TREAT_FATAL, SM_RELEASE_OBJ_ERR);
				count = -1; 
				goto bye;
			}
			userDescAux = NULL;
		}
	}  /* end while */
	DEBUGINFO
		"scan file %d.%d.%d line %d\n", 
		fid->pid.page, fid->pid.volid, fid->unique, __LINE__
	ENDINFO

	if(!appendUA) {
		check_visited(array, arraysize, fid->pid.volid);
	}

	if(interactive) {
		DEBUGINFO
		"\nData file contains %d objects.\n\n", count
		ENDINFO
	}

bye:

	if (e = sm_CloseScan(scanDesc)) {
		HANDLE_ERROR(CAUSE_SM, TREAT_FATAL, SM_CLOSESCAN_ERR);
		count = -1; 
	}
bye2:
	if(count < 0) {
	DEBUGINFO
		"scan file %d.%d.%d line %d\n", 
		fid->pid.page, fid->pid.volid, fid->unique, __LINE__
	ENDINFO
		/* will treat as fatal if not a cx error */
		HANDLE_ERRWRECONNECT(CAUSE_SM, TREAT_FATAL, NOVOLUME,fid->pid.volid,
			Numretries);
		/* should go to again */
		goto again;
	} else {
		checkNumBufs(__LINE__, __FILE__, FALSE);
	}
	clr_retry();
	return count;

}
