/*
 * $RCSfile: validate.c,v $
 * $Revision: 1.11 $
 * $Date: 1993/04/29 16:34:42 $
 */
#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>
#include "et.h"
#include "etError.h"
#include "func.h"


/********************************************************
 *
 *      validateVar
 *
 *******************************************************/
void validateVar(int argumentCount, int option1, int option2,
		int objCount, int *objNum, int *howMany)
{
	if (argumentCount == 2) {
		*objNum = 0;
		*howMany = objCount;
	} else if (argumentCount == 3)
	{
		*objNum = option1;
		*howMany = 1;
	} else {
		*objNum = option1;
		*howMany = option2;
	}
}


/********************************************************
 *
 *      diffObjHdr
 *
 *******************************************************/
BOOL diffObjHdr (OBJHDR  *objHdrPtrA, OBJHDR  *objHdrPtrB, BOOL changed, int objNum)
{
	BOOL	localChange=FALSE;

	/* check properties */
	if (objHdrPtrA->properties != objHdrPtrB->properties)
	{
	    localChange = TRUE;

	    if (!changed)
	    {
	    	printf("obj# %d :\tproperties changed\t", objNum);
		changed = TRUE;
	    }
	    else
	    	printf("properties changed\t");
	}

	/* check the tage */
	if (objHdrPtrA->tag != objHdrPtrB->tag)
	{
	    localChange = TRUE;

	    if (!changed)
	    {
	    	printf("obj# %d :\ttag changed\t", objNum);
		changed = TRUE;
	    }
	    else
	    	printf("tag changed\t");
	}

	/* check the object size */
	if (objHdrPtrA->size != objHdrPtrB->size)
	{
	    localChange = TRUE;

	    if (!changed)
	    {
	    	printf("obj# %d :\tsize changed\t", objNum);
		changed = TRUE;
	    }
	    else
	    	printf("size changed\t");
	}

	return localChange;
}



/********************************************************
 *
 *      validate 
 *
 *******************************************************/
int
count_objs_in_files( BOOL createUA, ObjInfo *array, int arraysize )
{
	int i = 0, j=0;

	/*
	 * sanity check:
	 * createUA true <--> array == NULL
	 */
	if(createUA) {
		if(array != NULL) {
			/* internal error */
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, NOINFO);
		}
	} else {
		if(array == NULL) {
			/* internal error */
			HANDLE_ERROR(CAUSE_ET, TREAT_FATAL, NOINFO);
		}
	}
	DEBUGINFO
		"Nvolumes %d\n", Nvolumes
	ENDINFO
	if(createUA) objUACount = 0; /* we can't 
		 	* initializez it in scanFile because 
		 	* we want each scan to APPEND
		 	*/
	for(j=0; j<Nvolumes; j++) {
		FID *fid = get_fid_of(Volids[j].volid);
		/* has side-effect of setting up volid info if this
		 * is called right after a recover
		 */
		DEBUGINFO
			"count objs in volume %d lastused %d fid %d.%d.%d\n", 
			Volids[j].volid, Volids[j].lastused, 
			fid?fid->pid.page:-1, fid?fid->pid.volid:-1, fid?fid->unique:-1
		ENDINFO
		if(Volids[j].lastused != NULL_TID) {
			int amount;

			/* for now we only handle one file per volume */
			DEBUGINFO
				"scan file (create=%d, objUACount=%d) in volume %d... ", 
				createUA, objUACount, Volids[j].volid
			ENDINFO
			set_retry();
			amount = scanFile(get_fid_of(Volids[j].volid), 
				Volids[j].temp, FALSE /* count them only */, createUA, array, arraysize );
			if(amount == -1) {
				HANDLE_ERRWRECONNECT(CAUSE_SM, TREAT_NONFATAL, SM_OPENSCAN_ERR,
					Volids[j].volid,  Numretries);
			}
			DEBUGINFO
				"... returns %d objects, objUACount is now %d\n", 
				amount, objUACount
			ENDINFO
			i += amount;
		}
	}
	DEBUGINFO
		"%d objects found in %d files\n",
		i, Nvolumes
	ENDINFO
	return i;
}

jmp_buf  where;
BOOL	ok2retry = FALSE;

int
validate(int bufGroup, int howMany, int objNum, ObjInfo *array)
{
	ObjInfo		*objinfo;
	/*
	 *  InvalidCount keeps a counter of the total number of
	 *  failed validations of an et session.
	 */
	extern int	InvalidCount;
	int 		i;
	int			totalObj = howMany;
	int			numOfObj=0;
	int			numOfValidObj=0;
	int			numOfInvalidObj=0;
	int			numDestroyed=0;
	OBJHDR		objHdr;
	USERDESC    *userDesc;
	BOOL		changed;
	int			*temp=(int *)0, tempLoc;
	int			count;
	extern		int setjmpretval; 

	set_retry();
	switch(setjmpretval) {
	case esmLOCKBUSY:
		/* give the servers time to agree */
		sleep(5);
		/* drop through */
	case esmTRANSABORTED:
		/* try again */
	case esmNOERROR:
		/* just called setjmp */
		break;
	default:
		/* tried enough times and failed */
		return esmFAILURE;
	}
	count = (array == UA)?objUACount:objCACount;
INFO
	"validate %d objs starting with obj %d\n", howMany, objNum
ENDINFO

	if (getenv("COREDUMP")) {
		temp = (int *)0; /* Will dump core on first error */
	} else {
		temp = &tempLoc; /* willl not dump core */
	}
	checkNumBufs(__LINE__, __FILE__, TRUE);

	objinfo = &array[objNum];
	for (changed = FALSE, i=objNum, objinfo = &array[objNum]; 
		i < objNum+howMany; 
		i++, objinfo++, changed=FALSE) {

		if ( i >= count) {
			HANDLE_ERROR(CAUSE_USER, TREAT_NONFATAL, INVALID_OBJ_NUM);
			break;
		}
		if (isDestroyed(objinfo,  0)) {
			numDestroyed++;
			continue;
		}

		numOfObj++;

		if (sm_ReadObjectHeader(bufGroup, &objinfo->objID, &objHdr)) {
			HANDLE_ERRWRECONNECT(CAUSE_VALIDATION, TREAT_INFO, 
				SM_READ_OBJ_HEADER_ERR, objinfo->objID.diskAddr.volid,
				Numretries);
			continue;	
		}
	
		if (sm_ReadObject(bufGroup, &objinfo->objID, 0,-1,&userDesc)){
			HANDLE_ERRWRECONNECT(CAUSE_VALIDATION, TREAT_INFO, 
				SM_READ_OBJ_ERR, objinfo->objID.diskAddr.volid,
				Numretries);
			continue;
		}
		/* once we have been able to read one... we'd like to 
		 * validate all
		 */
		clr_retry();

		if (objinfo->checkSum != 
			checkSum(userDesc->basePtr, (int)userDesc->objectSize)) {
			changed = TRUE;
		}
		if(objinfo->objHdr.tag != objHdr.tag) {
	    	printf("obj# %d :\ttag (%d) wrong(%d)\n", 
				i, objHdr.tag, objinfo->objHdr.tag);
			changed = TRUE;
		}
		if(objHdr.tag != objinfo->index) {
	    	printf("obj# %d :\ttag (%d) does not match index (%d)\n", 
				i, objinfo->objHdr.tag, objinfo->index);
			changed = TRUE;
		}

		if (diffObjHdr(&objHdr, &objinfo->objHdr, changed, i)) {
			changed = TRUE;
		} 

		if (changed) 	{
			INFO
				"Object # %d\n", i
			ENDINFO
			numOfInvalidObj++;
			HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, CHECKSUM);
			*temp = 10;
		} else {
			numOfValidObj++;
		}

		if (sm_ReleaseObject(userDesc)) {
			HANDLE_ERROR(CAUSE_SM, TREAT_NONFATAL, SM_RELEASE_OBJ_ERR);
		}

	}	/* end for-loop */
	checkNumBufs(__LINE__, __FILE__, FALSE);

	printf("\n");
	printf("Objects validated in OVF:\t%d\n", totalObj);
	printf("\tExisting  :\t%4d \tDestroyed :\t%4d\n",numOfObj, numDestroyed);
	printf("\tValid     :\t%4d \tInvalid   :\t%4d\n",numOfValidObj, numOfInvalidObj);

	/* if we're validating the whole batch, try a scan  */
	if(objNum == 0 && 
		(((howMany == objUACount) && (array == UA))
		||
		((howMany == objCACount) && (array == CA)))
	) {
		int i;
		i = count_objs_in_files( FALSE, array, totalObj );
		printf("Objects in files:\t%d\n", i);
		if(i < numOfObj) {
			HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, TOOMANY);
			goto bad;
		}
		if(i > numOfObj) {
			HANDLE_ERROR(CAUSE_VALIDATION, TREAT_INFO, TOOFEW);
			goto bad;
		}
	}

	clr_retry();
	return (numOfInvalidObj == 0)? esmNOERROR : esmFAILURE;
bad:
	clr_retry();
	return esmFAILURE;
}
