/*
 *	This file contains the main function to control the operation
 *	of a producer.
 */

#include <stdio.h>
#include "sm_client.h"

#include <stdlib.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "widget.h"
#include "error_handler.h"

main (int argc, char** argv)
{

	char		*producerName;
	int			widgetSize;		/* total size of widgets produced */
	int			numWidgets;		/* total # of widgets to produce */
	FID			widgetFid;
	char	    *errorMsg;

    /*
     *  Read the default configuration files to
     *  have the bufpages option set.
     */
    if (sm_ReadConfigFile(NULL, argv[0], &errorMsg) != esmNOERROR) {
        fprintf(stderr, "Configuration file error: %s\n", errorMsg);
        HANDLE_ERROR(sm_errno);
        exit(sm_errno);
    }

    /*
     *  Set any options from the command line
     */
    if (sm_ParseCommandLine(&argc, argv, &errorMsg) != esmNOERROR) {
        fprintf(stderr, "command line error: %s\n", errorMsg);
        HANDLE_ERROR(sm_errno);
        exit(0);
    }
    
	/*
	 *	check for the proper number of arguments
	 */
    if (argc != 4) {

		fprintf(stderr,"usage: %s name numWidgets widgetsize\n", argv[0]);
		exit(-1);
    }

	/*
	 *	get the parameters of the test
	 */
    producerName = argv[1];
    numWidgets = atoi(argv[2]);
    widgetSize = atoi(argv[3]);

    /* Initialize the storage manager.  */
    if (sm_Initialize() != esmNOERROR)	{
		HANDLE_ERROR(sm_errno);
		exit(sm_errno);
	}

	if (findWidgetVolume() != esmNOERROR) {
		exit(sm_errno);
	}

    /* Open a buffer group  */
    if (sm_OpenBufferGroup(20, BF_LRU, &global_bufgroup, NOFLAGS))	{
		HANDLE_ERROR(sm_errno);
		exit(sm_errno);
	}

	if (getWidgetFile(&widgetFid, WIDGET_ROOT_ENTRY) != esmNOERROR) {
		printf("Problem setting up widget file\n");
		exit(1);
	}

	if (produce(&widgetFid, numWidgets, widgetSize, producerName) != esmNOERROR) {
		printf("Problem producing widgets\n");
		exit(1);
	}

	/* Shut everything down */
    if (sm_CloseBufferGroup(global_bufgroup))	{
		printf("Error from sm_CloseBufferGroup: %s: %s\n", sm_ErrorId(sm_errno), sm_Error(sm_errno));
		exit(sm_errno);
	}

	/* Shutdown the volume */
    if (sm_ShutDown())	{
		printf("Error from sm_ShutDown: %s: %s\n", sm_ErrorId(sm_errno), sm_Error(sm_errno));
		exit(sm_errno);
	}

	exit(0);
}

