static char rcsid[] = "$Id: handler.c,v 1.2 1992/01/17 23:02:13 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *  Copyright 1993 Philippe-Andre Prindeville, Telecom Paris.
 *
 *****************************************************************************/

/*  handler.c
 *
 *    Contain action handlers for the parser to invoke upon a gdb command.
 *
 *    AdjustText():		Adjust the portion of text displayed.
 */

#include <ctype.h>
#include "global.h"
#include <Xm/Xm.h>
#include <Xm/Text.h>

Boolean		Echo = True;		/* display gdb output if true */
static Boolean	Skip_func_handler = False;

/*
 *  Adjust text so that 'line' will fall into the viewable part of the
 *  source window.
 *  Arrows, stop signs, and line label and Vertical Scroll bar
 *  are updated accordingly.
 */
void AdjustText(line)
    int	   	line;
{
    FileRec 		*file;
    int	    		nlines = 0;
    int			i, topline;
    XmTextPosition 	pos;
    Dimension width;
    Arg                 args[5];

    if ((file = displayedFile) == NULL || line <= 0) return;
    file->currentline = line;

    if (line < file->topline || line > file->bottomline ) {
	/* Position line about 30% from the top */
	nlines = file->lines / 3;
	if (line < nlines)			   /* near top */
	    topline = 1;
	else if (line > file->lastline - file->lines)  /* near bottom */
	    topline = MAX(file->lastline - file->lines + 1, 1);
	else
	    topline = line - nlines;

	/*
	 * Change the scrollbar value, asking for a callback to
	 * refresh the text window and the drawingArea at the same
	 * time...
	 */
	ScrollBarSetValues(scrollV, topline, -1, -1, -1, True);
    }

    XmTextSetInsertionPosition(sourceWindow, file->linepos[line]);

    if (line <= file->lastline)
      UpdateLineLabel(line);
    else
      UpdateMessageWindow("Line number is out of range.", NULL);
    UpdateSigns(file);
}
