.\"$Id: mxgdb.man,v 1.2 1992/03/25 17:48:24 jtsillas Exp $
.TH MXGDB 1 "Jan 10 1992" "X Version 11/OSF Motif"
.SH NAME
mxgdb \- Motif based X window system interface to the gdb debugger.
.SH SYNOPSIS
.B mxgdb
[ \fI-toolkitoption ... \fP] [\fI-mxgdboption ... \fP] [\fI-gdboption ... \fP] [\fIobjfile\fP 
[ \fIcorefile\fP ]]
.SH DESCRIPTION 
\fIMxgdb\fP is a Motif based graphical user interface to
the \fIgdb\fP debugger under the X Window System.  It provides visual
feedback and mouse input for the user to control program execution
through breakpoints, to examine and traverse the function call stack, to
display values of variables and data structures, to browse source files
and functions and to obtain help on \fIgdb\fP commands and options.
.LP 
\fIMxgdb\fP allows initial \fIgdb\fP commands stored in the 
file \fI.gdbinit\fP to be executed immediately after the symbolic information
is read.  If \fI.gdbinit\fP does not exist in the current directory, the
user's home directory is searched (\fI~/.gdbinit\fP).
.LP 
\fIObjfile\fP is an object file produced by a compiler with the
appropriate option (\fB-g\fP) specified to produce symbol table
information for \fIgdb\fP.  If no \fIobjfile\fP is specified, the
\fBfile\fP command can be used later to specify the program to be
debugged.
.LP 
If a file named \fIcore\fP exists in the current directory or a
\fIcorefile\fP is specified, \fImxgdb\fP can be used to examine the
state of the program when the core dump occurred.
.LP 
The name of the debugger invoked by \fImxgdb\fP is, by default,
\fIgdb\fP, but it can be overridden with the environment variable
MXGDB_DEBUGGER. Likewise the prompt used by \fIgdb\fP can be overriden by the
environment variable GDB_PROMPT.
.SH OPTIONS 
\fIMxgdb\fP accepts all of the standard X Toolkit command
line options (see \fIX\fP(1)), and all the \fIgdb\fP options (see
\fIgdb(1)\fP), plus the following \fImxgdb\fP specific options:
.TP 
.B \-bigicon 
Uses a 64x64 icon instead of the default 48x48 icon.
.TP 
.B \-cmdd 
Uses a separate detached window to hold command buttons instead of the
default button layout in the \fBSource Window\fP.
.SH WINDOW PANES 
The \fImxgdb\fP interface consists of the following
window panes:
.IP "\fBMenu Pane\fP" 20 
Provide access to the \fIFile\fP,
\fICommands\fP and \fIHelp\fP pulldown menus.
.IP "\fBFile Window\fP" 20 
Display the full pathname of the file
displayed in the source window, and the line number of the caret.
.IP "\fBSource Window\fP" 20 
Display the contents of a source file and
provides a set of buttons of the common \fIgdb\fP commands which are
invoked by pressing the LEFT mouse button down. Browsing text in the
window is possible via the cursor keys, pg up/down, and the vertical
scroll bar (see \fBSCROLLBAR\fP).  viewing lines greater than the
window's width is possible through the \fBleft page\fP and \fBright
page\fP command buttons.
.IP "\fBMessage Window\fP" 20 
Display the execution status and error
messages of \fImxgdb\fP.
.IP "\fBDialogue Window\fP" 20 
Provide a typing interface to \fIgdb\fP
which is identical to the \fIgdb\fP command line interface with the
exception that \fImxgdb\fP reserves the right to intercept output for
its own interpretation and use.
.LP 
The relative sizes of the \fBSource Window\fP and the \fBDialogue
Window\fP can be adjusted by dragging the grip (a small square near the
right edge of a horizontal border) with the LEFT mouse button down.
Ordering of the command buttons in the \fBSource Window\fP will not
change when the window is resized but the height of the buttons will
change to completely fill the height of the window.
.SH DIALOG WINDOWS 
\fIMxgdb\fP can optionally display the following
dialog windows:
.IP "\fBDisplay Window\fP" 20 
Provide a window with a scrolling work
area for displaying variables each time execution stops.
.IP "\fBHelp Window\fP" 20 
Provide a window for access to gdb's built in
help functions. The basic components of this window are a scrolling work
area and a command line. The work area contains \fIgdb's\fP help text
menu where the commands and categories are placed in buttons. Selecting
these buttons accesses help more specific to the respective command or
category. The command line always contains a \fIQuit\fP button, which
will remove the \fBHelp Window\fP if chosen, and optionally an \fIUp
Arrow\fP button which only appears if you have chosen an additional help
selection from the work area. In this case choosing the \fIUp Arrow\fP
button will return you to the previous help text menu.
.IP "\fBFile Selection Window\fP" 20 
Provide a window for selection of
directories, executables and source files. The \fBFile Selection
Window\fP consists of five basic components: a \fIFilter\fP, which can
be edited and which affects what appears in the \fIDirectories\fP list
and the \fIFiles\fP list, a \fISelection\fP which can either be edited
or altered by selecting elements of the \fIDirectories\fP or \fIFiles\fP
lists, and a set of \fIButtons\fP which control the use of the
\fISelection\fP contents.  The \fBFile Window\fP initially starts by
displaying the current directory and its contents. You can use the
\fIFiler\fP button to change the displayed directory or to restrict the
set of files which are displayed in the \fIFiles\fP list. Selecting the
\fIOK\fP button will provide a listing of the file if it is one fo the
current source files, will use it as the exec-file and symbol-file if it
is executable or will add it to the source path if it is a directory.
Selecting the \fICancel\fP button will remove the \fBFile Selection
Window\fP without executing any commands.
.IP "\fBSearch Window\fP" 20
Provide a window for searching through the
contents of the \fBSource Window\fP. This window has five components: a
\fISelection\fP which is edited for the string to search for, a
\fIDown\fP button which scans the \fBSource Window\fP for occurrences of
the \fISelection\fP down from the current line, an \fIUp\fP button which
scans the \fBSource Window\fP for occurrences of the \fISelection\fP up
from the current line, a \fICancel\fP button which ends the search and
returns the text to the original line, and a \fIStop\fP button which
ends the search but stays at the current line.
.IP "\fBCommands Window\fP" 20 
Provide a window to contain the command
buttons (appears only if \fImxgdb\fP was invoked with \fB-cmdd\fP or if
the \fBuseCommandDialog\fP resource is set to \fITrue\fP).
.IP "\fBXtty Window\fP" 20 
Provide a pseudo-tty device through an
\fIxterm\fP for use by the debug process for character I/O. This
pdeudo-device uses the \fIxterm\fP terminal type and is configured with
the following terminal settings: \fIintr = DEL; quit = ^|; erase = ^h;
kill = ^u; eof = ^d; eol = ^` swtch = ^z; susp = ^z \-parenb \-parodd
cs8 \-cstopb hupcl cread \-clocal \-loblk \-ignbrk brkint ignpar
\-parmrk \-inpck \-istrip \-inlcr \-igncr icrnl \-iuclc \-ixon \-ixany
\-ixoff isig icanon \-xcase echo echoe echok echonl \-noflsh \-tostop
\-iexten opost \-olcuc onlcr \-ocrnl \-onocr \-onlret \-ofill \-ofdel\fP
.IP "\fBExit Window\fP" 20
Asks the user if he really wishes to exit \fImxgdb\fP. Selecting \fIOK\fP 
will exit \fImxgdb\fP immediately. Selecting \fICancel\fP will remove the 
window and return to \fImxgdb\fP.
.IP "\fBInfo Window\fP" 20
Provides a window containing the authors' names, the current versions and
date and any additional information on this version.
.SH PULL DOWN MENUS
The following pull menus are provided with \fImxgdb\fP:
.IP "\fBFile\fP" 20
.LP
.IP "\fIFile...\fP" 20
Invoke the \fBFile Selection Window\fP dialog.
.IP "\fISearch...\fP" 20
Invoke the \fBSearch Window\fP dialog.
.IP "\fICommands...\fP" 20
Redisplay the \fBCommands Window\fP dialog (this is only sensitive if
the \fBCommands Window\fP is being used).
.IP "\fIXtty...\fP" 20
Invoke the \fBXtty Window\fP and direct \fIgdb\fP to use it (via
\fIgdb's stty\fP function). Selecting \fIXtty\fP a second time will
remove the \fBXtty Window\fP and reset \fIgdb\fP to use the normal I/O
terminal.
.IP "\fIExit...\fP" 20
Presents the \fBExit Window\fP and asks if you wish to exit \fImxgdb\fP.
.LP
.IP "\fBCommands\fP" 20
The entries in the \fBCommands\fP menu contains the following groups
of \fIgdb\fP commands:
.IP "\fIRunning\fP" 20
\fIrun continue next step finish\fP
.IP "\fIData\fP" 20
\fIprint display undisplay\fP
.IP "\fIBreakpoints\fP" 20
\fIbreak clear tbreak\fP
.IP "\fIStack\fP" 20
\fIup down\fP
.IP "\fIInfo\fP" 20
\fIlocals args stack\fP
.LP
.IP "\fBHelp\fP" 20
.IP "\fIGdb Help...\fP" 20
Invokes the \fBHelp Window\fP dialog.
.IP "\fIInfo...\fP" 20
Invokes the \fBInfo Window\fP dialog.
.SH KEY BINDINGS AND ACCELLERATORS
\fIMxgdb\fP uses the following key bindings in the respective windows:
.IP "\fBSource Window\fP" 20
(add later)
.IP "\fBDialog Window\fP" 20
(add later)
.LP
\fIMxgdb\fP defines the following accellerator keys:
.IP "\fBCntrl-f\fP" 20
Invokes the \fBFile Selection Window\fP.
.IP "\fBCntrl-x\fP" 20
Invokes the \fBExit Window\fP.
.IP "\fBCntrl-w\fP" 20
Invokes the \fBSearch Window\fP.
.IP "\fBCntrl-r\fP" 20
Executes the \fIrun\fP command.
.IP "\fBCntrl-n\fP" 20
Executes the \fInext\fP command.
.IP "\fBCntrl-s\fP" 20
Executes the \fIstep\fP command.
.IP "\fBCntrl-p\fP" 20
Executes the \fIprint\fP command.
.IP "\fBCntrl-b\fP" 20
Executes the \fIbreak\fP command.
.IP "\fBCntrl-g\fP" 20
Executes the \fIup\fP command.
.IP "\fBCntrl-j\fP" 20
Executes the \fIdown\fP command.
.IP "\fBCntrl-h\fP" 20
Invokes the \fBHelp Window\fP.
.SH SELECTION
Text selection in the source window is modified to make it easier to
select C expressions.  Using the LEFT mouse button in combination with
the SHIFT key selects a C expression by highlighting it in
reverse-video. LEFT mouse button down alone positions the caret and
updates the line label accordingly.
.LP
C expression selection is based on the resource \fIdelimiters\fP which
determines the set of characters that delimits a C expression. Text
selection adjustment is possible by holding the LEFT mouse button down
and dragging.
.LP
To paste a selection in the \fBDialog Window\fP press the MIDDLE mouse
button down. The selection will be put on the mxgdb command line only
and cannot be inserted anywhere but the command line. A selection may
be inserted from any text selection available on the given display.
.LP
Selection of displayed varables in the \fBDisplay Window\fP is also
made easier.  Using the LEFT mouse button down on the line containing
the variable name the displayed variable is automatically selected by
its number (see the description of the \fBundisplay\fP command
button).
.LP
.SH SCROLLBAR
Pressing the LEFT mouse button scrolls the text forward, whereas
pressing the RIGHT mouse button scrolls the text backward.  The amount
of scrolling depends on the distance of the pointer button away from
the top of the scrollbar.  If the button is pressed at the top of the
scrollbar, only one line of text is scrolled.  If the button is pressed
at the bottom of the scrollbar, one screenful of text is scrolled.
.LP
Pressing the MIDDLE mouse button changes the thumb position of the
scrollbar.  Dragging the MIDDLE mouse button down moves the thumb along
and changes the text displayed.
.SH COMMAND BUTTONS
The \fImxgdb\fP command buttons are positioned either in the left margin
of the \fBSource Window\fP (by default) or in the \fBCommand Window\fP
dialog. The buttons are situated vertically in two columns and
correspond (from top to bottom).  The following commands can be chosen
by pressing the LEFT mouse button down within the command button:
.IP "\fBrun\fP" 10
Begin program execution.
.IP "\fBstack\fP" 10
Show a stack trace of the functions called.
.IP "\fBlocals\fP"
Print the local variables of the selected frame, each on a separate line.
These are all variables declared static or automatic within all program blocks
that execution in this frame is currently inside of.
.IP "\fBup\fP"
Move up one level on the call stack.
.IP "\fBargs\fP"
Print the arguments of the selected stack frame, each on a separate line.
.IP "\fBdown\fP"
Move down one level on the call stack.
.IP "\fBprint *\fP"
Print the value of the object the selected expression is pointing to.
.IP "\fBprint\fP" 10
Print the value of a selected expression.
.IP "\fBcont\fP"
Continue execution from where it stopped.
.IP "\fBstep\fP"
Execute one source line, stepping into a function if the source line
contains a function call.
.IP "\fBfinish\fP"
Continue execution until the selected procedure
returns; the current procedure is used if none is selected.
.IP "\fBnext\fP"
Execute one source line, without stepping into any function call.
.IP "\fBclear\fP"
Remove the breakpoint on the source line selected or the function name
selected.
.IP "\fBbreak\fP" 10
Stop program execution at the line selected.  To set a breakpoint in the
program, place the caret on the source line and choose the \fBbreak\fP
button.  A \fIstop\-sign\fP will appear next to the source line.  To set
a breakpoint in a function, select the function name and choose the
\fBbreak\fP button.  A \fIstop\-sign\fP will be placed near the first
executable line of the function.
.IP "\fBundisplay\fP"
Stop displaying the value of the selected expression in the \fBDisplay
Window\fP dialog.  If the selected expression is a constant, it refers
to the display number associated with an expression in the display
window.
.IP "\fBdisplay\fP"
Display the value of a selected expression in the \fBDisplay Window\fP
dialog, updating its value every time execution stops.
.IP "\fBleft page\fP"
Shift the \fBSource Window\fP contents to the left so that lines longer
that the width of the \fBSource Window\fP can be made visible.
.IP "\fBright page\fP"
Shift the \fBSource Window\fP contents to the right.
.SH X DEFAULTS
To change the default values of widget resources used in \fImxgdb\fP,
you need to reference the widgets by name or by class.  The widget
hierarchies for the window panes and the dialog windows are given in the
file \fI/usr/lib/X11/app-defaults/Mxgdb\fP. These can overriden by making
similar entries in the \fI.Xdefaults\fP file in you home directory.
In addition to the standard X resources, \fImxgdb\fP uses the following
application-specific resources for user customization.  The value in
parentheses is the default value.
.IP \fBbell\fP
If True, the bell is on. (True)
.IP \fBdisplayWindow\fP
If True, the display window appears on start up. (False)
.IP \fBdelimiters\fP
The set of delimiters for word selection. (" !%^&*()+=~|;:{},/#<?\"\n\t")
.IP \fBprompt\fP
The prompt string used in mxgdb. ("(mxgdb) ")
.IP \fBbutton_color\fP
Color of all of the buttons not specified below. (Black)
.IP \fBstop_color\fP
Color of the stop sign, and set/clear breakpoint buttons. (Red)
.IP \fBarrow_color\fP
Color of the arrow sign, and the right/left scroll buttons. (Blue)
.IP \fBupdown_color\fP
Color of the updown sign, and the up/down stack buttons. (Blue)
.IP \fBbomb_color\fP
Color of the bomb sign. (Red)
.LP

.SH FILES
.nf
a.out 		default object file
core 		default core file
\&.gdbinit 	local initial commands file
~/.gdbinit 	user's initial commands file
.SH SEE ALSO
X(1), gdb(1)
.SH LIMITATIONS

.SH BUGS
Output from the debug program can fool the mxgdb parser if an Xtty
Window is not used to manage I/O from the debug process. A separate
asynchronous pseudo-tty should be used as the default means of I/O
with the debug process.

.SH COPYRIGHT
Derived from manpage from xxgdb(1)
Derived from manpage from xdbx(1)
Copyright 1989 The University of Texas at Austin
Copyright 1990 Microelectronics and Computer Technology Corporation
Copyright 1991 Bull HN

.SH AUTHOR
Po Cheung (xdbx(1))
Jim Tsillas (mxgdb(1))
