-------------------------------------------------------------------------------
--                                                                           --
--               Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--                         Darren J Moffat                                   --
--                      moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: Wed Mar  1 21:44:55 1995
-- $RCSfile: mousetest.adb,v $
-- $Revision: 1.1 $
-- $Author: djm $
--
-- $Log: mousetest.adb,v $
-- Revision 1.1  1995/03/01  23:36:25  djm
-- Initial revision
--


 
with
  SVGALib,
  SVGALibMouse,
  Text_IO;
use
  SVGALib, 
  SVGALibMouse,
  Text_IO;

procedure MouseTest is
   package Int_IO is new Integer_IO (Integer); use Int_IO;

   Mouse_Point : Point;
   GlobalMode : VgaMode := G640x480x256;

begin
    
   Set_Mode (GlobalMode);
   Screen_On;
   Mouse_Init (MouseSystems);
   Set_Default_Event_Handler;
   Mouse_Set_Position ((Get_Xdim/2, Get_Ydim/2));
   loop
      Mouse_Wait_For_Update;
      Mouse_Point := Mouse_Get_Position;
      Put ("Drawing at Point: (");
      Put (Mouse_Point.X); Put (",");
      Put (Mouse_Point.Y); Put (").");
      New_Line;
      Draw_Point (Mouse_Point);
   end loop;

end MouseTest;
