-------------------------------------------------------------------------------
--                                                                           --
--               Ada95 Bindings to Linux SVGA Library                        --
--                                                                           --
--                         Darren J Moffat                                   --
--                      moffatd@dcs.gla.ac.uk                                --
--                                                                           --
-- These bindings may be distributed under the same agreement as holds for   --
-- the current version of SVGALib.  With the additional condition that my    --
-- name must not be removed from any of the Ada source files.                --
--                                                                           --
-------------------------------------------------------------------------------
-- Last Modified: 
-- $RCSfile: svgalibmouse.adb,v $
-- $Revision: 1.1 $
-- $Author: djm $
-- $Log: svgalibmouse.adb,v $
-- Revision 1.1  1995/02/08  00:57:42  djm
-- entered into RCS
--
 
with
  Interfaces.C,
  SVGALib;
use
  Interfaces.C,
  SVGALib;

package body SVGALibMouse is


   procedure Mouse_Init (MT : MouseType := Microsoft;
			 Device : String := "/dev/mouse";
			 Rate : Integer := Default_Sample_Rate) is

      function C_Mouse_Init (D : String; T : MouseType; Rate : Integer)
			     return Boolean;
      pragma Import (C, C_Mouse_Init, "mouse_init");
   begin
      if not C_Mouse_Init (Device, MT, Rate) then
	 raise Mouse_Error;
      end if;
   end Mouse_Init;

   procedure Mouse_Set_Position (P : Point) is
      procedure C_Mouse_Set_Position (X, Y : Integer);
      pragma Import (C, C_Mouse_Set_Position, "mouse_setposition");
   begin
      C_Mouse_Set_Position (P.X, P.Y);
   end Mouse_Set_Position;


   function Mouse_Get_Position return Point is
      function C_Mouse_Get_X return Integer;
      pragma Import (C, C_Mouse_Get_X, "mouse_getx");
      function C_Mouse_Get_Y return Integer;
      pragma Import (C, C_Mouse_Get_Y, "mouse_gety");
   begin
      return (C_Mouse_Get_X, C_Mouse_Get_Y);
   end Mouse_Get_Position;
   

end SVGALibMouse;
