------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--             A D A . T E X T _ I O . T E X T _ S T R E A M S              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO.Aux;
with Ada.Streams; use Ada.Streams;

package body Ada.Text_IO.Text_Streams is

   --  Package defining the Stream type we will return

   package Text_IO_Stream_Def is

      type Text_IO_Stream is new
         Ada.Streams.Root_Stream_Type
      with record
         File : File_Type;
      end record;

      procedure Read
        (Stream : in out Text_IO_Stream;
         Item   : out Stream_Element_Array;
         Last   : out Stream_Element_Offset);

      procedure Write
        (Stream : in out Text_IO_Stream;
         Item   : in Stream_Element_Array);

   end Text_IO_Stream_Def;

   package body Text_IO_Stream_Def is

      procedure Read
        (Stream : in out Text_IO_Stream;
         Item   : out Stream_Element_Array;
         Last   : out Stream_Element_Offset)
      is
      begin
         Ada.Text_IO.Aux.Read (Stream.File, Item, Last);
      end Read;

      procedure Write
        (Stream : in out Text_IO_Stream;
         Item   : in Stream_Element_Array)
      is
      begin
         Ada.Text_IO.Aux.Write (Stream.File, Item);
      end Write;
   end Text_IO_Stream_Def;

   ------------
   -- Stream --
   ------------

   function Stream (File : in File_Type) return Stream_Access is
      use Text_IO_Stream_Def;
   begin
      return
        Stream_Access'
          (new Text_IO_Stream'(Root_Stream_Type with File));
   end Stream;

end Ada.Text_IO.Text_Streams;
