//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventLIterator.h,v 0.27 1995/01/20 15:14:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNEventLIterator --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1995   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@dfv.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 **EHEADER********************************************************************/

#ifndef __CNEventLIterator_h
#define __CNEventLIterator_h


#include <CNCL/EventIterator.h>		// Base class
#include <CNCL/EventList.h>

extern CNClassDesc CN_EVENTLITERATOR;	// Class CNEventLIterator description


/*
 * The class CNEventLIterator
 */

class CNEventLIterator : public CNEventIterator
{
    friend class CNEventScheduler;
    
  private:	/***** Constructors ******************************************/
    CNEventLIterator() {}				// Default constructor
    CNEventLIterator(CNParam *param) {}			// CNParam constructor
    CNEventLIterator(CNEventList*);
    
  public:	/***** Public interface **************************************/
    CNEvent *next_event();	  // returns an event
    void delete_current_event();  // deletes last returned event
    
  private:	/***** Internal private members ******************************/
    CNEventList *elist;	          // says it all


  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTLITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTLITERATOR ? TRUE : CNEventIterator::is_a(desc); }
        
    static CNEventLIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventLIterator *)obj;
#   else
	return (CNEventLIterator *)( !obj || obj->is_a(CN_EVENTLITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTLITERATOR) );
#   endif
    }
  
  private:  
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNEventLIterator(param) : new CNEventLIterator; }
  
  public:  
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNEventLIterator &obj);
ostream &operator << (ostream &strm, const CNEventLIterator *obj);

#endif /**__CNEventLIterator_h**/
